/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url.handler;

import cn.com.duibabiz.component.filters.bloom.url.handler.PathHandler;
import cn.com.duibabiz.tools.strategy.AbstractStrategyFactory;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PathStrategyFactory
extends AbstractStrategyFactory<String, PathHandler> {
    private final Map<String, PathHandler> interceptUrlMap = new HashMap<String, PathHandler>();

    @Override
    public String generateKey(PathHandler pathHandler) {
        return (String)pathHandler.pathPair().getKey();
    }

    @Override
    protected void register(Map<String, PathHandler> map) {
        super.register(map);
        for (PathHandler pathHandler : map.values()) {
            this.interceptUrlMap.putIfAbsent((String)pathHandler.pathPair().getValue(), pathHandler);
        }
    }

    public PathHandler getHandlerByInterceptUrl(String path) {
        return this.interceptUrlMap.get(path);
    }

    public Set<String> getTotalUrls() {
        Set keys = super.getKeys();
        LinkedHashSet<String> set = new LinkedHashSet<String>(keys);
        for (String key : keys) {
            PathHandler handler = (PathHandler)this.getHandler(key);
            set.add((String)handler.pathPair().getValue());
        }
        return set;
    }
}

