/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.basic;

import cn.com.duibabiz.component.filters.bloom.basic.BitMapUtil;
import cn.com.duibabiz.component.filters.bloom.basic.BloomFilterConfig;
import cn.com.duibabiz.component.filters.bloom.basic.GrowKeyUtil;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisBloomFilter
implements ApplicationContextAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(RedisBloomFilter.class);
    private StringRedisTemplate stringRedisTemplate;
    private final BloomFilterConfig bloomFilterConfig;

    public RedisBloomFilter(int growBuffer, int expectedInsertions, double fpp) {
        this.bloomFilterConfig = new BloomFilterConfig(growBuffer, expectedInsertions, fpp);
        LOGGER.info("RedisBloomFilter init done,\u6570\u636e\u91cf={},\u5047\u9633\u6027\u6982\u7387={},\u6269\u5bb9\u4e34\u754cbuffer={}", new Object[]{this.bloomFilterConfig.getExpectedInsertions(), this.bloomFilterConfig.getFpp(), this.bloomFilterConfig.getGrowBuffer()});
    }

    private Set<String> getFilterKeys(String key) {
        return this.stringRedisTemplate.opsForSet().members((Object)key);
    }

    public boolean put(String key, String value, Date expireAt) {
        Long add;
        String filterKey;
        boolean newKey = false;
        Set<String> filterKeys = this.getFilterKeys(key);
        if (CollectionUtils.isEmpty(filterKeys)) {
            filterKey = GrowKeyUtil.genFirstKey(key);
            add = this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])new String[]{filterKey});
            if (add != null && add == 1L) {
                newKey = true;
            }
            this.stringRedisTemplate.expireAt((Object)key, expireAt);
        } else {
            filterKey = GrowKeyUtil.findLatest(filterKeys);
        }
        if (!newKey && this.needGrow(filterKey)) {
            filterKey = GrowKeyUtil.genNextKey(filterKey);
            add = this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])new String[]{filterKey});
            if (add != null && add == 1L) {
                newKey = true;
            }
        }
        int[] offset = this.bloomFilterConfig.murmurHashOffset(value);
        BitMapUtil.putWithPipeline(this.stringRedisTemplate, filterKey, offset, expireAt);
        return newKey;
    }

    private boolean needGrow(String filterKey) {
        float max;
        boolean needGrow;
        long approximateElementCount = this.approximateElementCount(filterKey);
        boolean bl = needGrow = (float)approximateElementCount > (max = (float)(this.bloomFilterConfig.getExpectedInsertions() - this.bloomFilterConfig.getGrowBuffer()));
        if (needGrow) {
            LOGGER.info("RedisBloomFilter,\u9700\u8981\u6269\u5bb9,filterKey={},\u5f53\u524d={},\u6269\u5bb9\u8981\u6c42={}", new Object[]{filterKey, approximateElementCount, Float.valueOf(max)});
        }
        return needGrow;
    }

    private long approximateElementCount(String filterKey) {
        Long bitCount = BitMapUtil.bitCount(this.stringRedisTemplate, filterKey);
        int bitSize = this.bloomFilterConfig.getBitSize();
        int numHashFunctions = this.bloomFilterConfig.getNumHashFunctions();
        double fractionOfBitsSet = (double)bitCount.longValue() / (double)bitSize;
        return DoubleMath.roundToLong((double)(-Math.log1p(-fractionOfBitsSet) * (double)bitSize / (double)numHashFunctions), (RoundingMode)RoundingMode.HALF_UP);
    }

    public Map<String, Long> info(String key) {
        Set<String> filterKeys = this.getFilterKeys(key);
        if (filterKeys == null || filterKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> map = new HashMap<String, Long>(filterKeys.size() * 2);
        if (!CollectionUtils.isEmpty(filterKeys)) {
            for (String filterKey : filterKeys) {
                map.put(filterKey, this.approximateElementCount(filterKey));
            }
        }
        return map;
    }

    public boolean mightContain(String key, String value) {
        Set<String> filterKeys = this.getFilterKeys(key);
        if (CollectionUtils.isEmpty(filterKeys)) {
            return false;
        }
        int[] offset = this.bloomFilterConfig.murmurHashOffset(value);
        for (String filterKey : filterKeys) {
            if (!BitMapUtil.mightContainWithPipeline(this.stringRedisTemplate, filterKey, offset)) continue;
            return true;
        }
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.stringRedisTemplate = (StringRedisTemplate)applicationContext.getBean(StringRedisTemplate.class);
        if (this.stringRedisTemplate == null) {
            throw new IllegalStateException("there must exists a bean of class StringRedisTemplate");
        }
    }
}

