/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessLocal;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathMapperFactory;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathParserFactory;
import cn.com.duibabiz.component.filters.bloom.url.path.PathMapping;
import cn.com.duibabiz.component.filters.bloom.url.path.PathParser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PathInterceptInterceptor
implements HandlerInterceptor,
ApplicationContextAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathInterceptInterceptor.class);
    private UrlSerialAccessFilter urlSerialAccessFilter;
    private PathParserFactory pathParserFactory;
    private PathMapperFactory pathMapperFactory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.urlSerialAccessFilter = (UrlSerialAccessFilter)applicationContext.getBean(UrlSerialAccessFilter.class);
        this.pathParserFactory = (PathParserFactory)applicationContext.getBean(PathParserFactory.class);
        this.pathMapperFactory = (PathMapperFactory)applicationContext.getBean(PathMapperFactory.class);
        if (this.pathParserFactory == null) {
            throw new IllegalStateException("there must exists a bean of class PathStrategyFactory");
        }
        if (this.urlSerialAccessFilter == null) {
            throw new IllegalStateException("there must exists a bean of class UrlSerialAccessFilter");
        }
        if (this.pathMapperFactory == null) {
            throw new IllegalStateException("there must exists a bean of class PathMapperFactory");
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathMapping pathMapping = (PathMapping)this.pathMapperFactory.getHandler(uri);
            if (pathMapping != null) {
                PathParser interceptPathParser = pathMapping.getInterceptPathParser();
                PathParser recordPathParser = pathMapping.getRecordPathParser();
                Pair<Boolean, String> pair = this.urlSerialAccessFilter.hasRecord(interceptPathParser, cid, recordPathParser.getPath());
                UrlSerialAccessLocal.set(pair);
            } else {
                LOGGER.info("urlSerialAccessService,intercept,pathMapping is NULL,cid={},path={},", (Object)cid, (Object)uri);
            }
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,intercept,exception,cid={},path={}", new Object[]{cid, uri, e});
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        UrlSerialAccessLocal.clear();
    }
}

