/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duibabiz.component.filters.bloom.url.factory.PathMapperFactory;
import cn.com.duibabiz.component.filters.bloom.url.interceptor.PathInterceptInterceptor;
import cn.com.duibabiz.component.filters.bloom.url.interceptor.PathRecordInterceptor;
import com.alibaba.fastjson.JSON;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Order(value=999)
@Configuration
@ConditionalOnBean(value={PathInterceptInterceptor.class, PathRecordInterceptor.class, PathMapperFactory.class})
public class PathMvcConfig
extends WebMvcConfigurerAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathMvcConfig.class);
    @Resource
    private PathInterceptInterceptor pathInterceptInterceptor;
    @Resource
    private PathRecordInterceptor pathRecordInterceptor;
    @Resource
    private PathMapperFactory pathMapperFactory;

    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        PathMvcConfig.registryPathInterceptor(registry, this.pathRecordInterceptor, this.pathMapperFactory.getRecordPaths());
        PathMvcConfig.registryPathInterceptor(registry, this.pathInterceptInterceptor, this.pathMapperFactory.getKeySet());
    }

    private static void registryPathInterceptor(InterceptorRegistry registry, HandlerInterceptor handlerInterceptor, Set<String> paths) {
        if (CollectionUtils.isNotEmpty(paths)) {
            registry.addInterceptor(handlerInterceptor).addPathPatterns(paths.toArray(new String[0]));
            LOGGER.info("addInterceptors success,paths={}", (Object)JSON.toJSONString(paths));
        }
    }
}

