/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.cros;

import cn.com.duiba.biz.tool.duiba.cros.UrlUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CrossDomainUtils {
    private CrossDomainUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void crossDomain(HttpServletRequest request, HttpServletResponse response) {
        CrossDomainUtils.crossDomain(request, response, null);
    }

    public static void crossDomain(HttpServletRequest request, HttpServletResponse response, String systemDomain) {
        String domain = request.getHeader("Origin");
        if (domain != null && (domain.endsWith("duiba.com.cn") || domain.endsWith("tuistone.com"))) {
            response.setHeader("Access-Control-Allow-Origin", UrlUtils.addScheme(domain, request));
            CrossDomainUtils.setCrosResponseHeader(response);
            return;
        }
        if (systemDomain != null && (systemDomain.endsWith("duiba.com.cn") || systemDomain.endsWith("tuistone.com"))) {
            response.setHeader("Access-Control-Allow-Origin", UrlUtils.addScheme(systemDomain, request));
            CrossDomainUtils.setCrosResponseHeader(response);
            return;
        }
    }

    private static void setCrosResponseHeader(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Methods", "POST,GET");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with");
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }
}

