/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.daily;

import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
public class BasicConConfig
implements InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(BasicConConfig.class);

    @Bean
    public UrlSerialAccessFilter urlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        return new UrlSerialAccessFilter(dailyRedisBloomFilter);
    }

    @Bean
    @ConditionalOnMissingBean(value={DailyRedisBloomFilter.class})
    public DailyRedisBloomFilter dailyRedisBloomFilter(RedisBloomFilter redisBloomFilter) {
        return new DailyRedisBloomFilter(2, redisBloomFilter);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisBloomFilter.class})
    @ConditionalOnClass(value={StringRedisTemplate.class})
    public RedisBloomFilter redisBloomFilter() {
        return new RedisBloomFilter(5000, 200000, 0.001);
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.info("BasicConConfig-\u81ea\u52a8\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6bd5");
    }
}

