/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.client;

import cn.com.duiba.biz.tool.duiba.dto.ConsumerCookieDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.idmaker.service.api.client.kms.KmsClient;
import cn.com.duiba.idmaker.service.api.dto.kms.TimeBasedRollingKeyDto;
import cn.com.duiba.idmaker.service.api.enums.kms.KeyTypeEnums;
import cn.com.duiba.idmaker.service.api.enums.kms.KeyUseTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.kms.RemoteKmsService;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class DuibaConsumerCookieClient {
    protected static final String CONSUMER_WDATA4_COOKIE = "wdata4";
    private static final String COMMERCIAL_CONSUMER_WDATA3_COOKIE = "wdata3";
    private static final String COMMERCIAL_LZLJ_INFO_COOKIE = "lzlj_info";
    private static final String CONSUMER_YJQ_INFO_COOKIE = "yjq_info";
    protected static final String LOGIN_TIME_COOKIE = "w_ts";
    protected static final String YJQ_LOGIN_TIME_COOKIE = "yjq_ts";
    protected static final String TOKEN_ID_COOKIE = "tokenId";
    private static final String X_HOST = "xhost";
    private static final int PERIOD_FOR_EVER = 315360000;
    private static final int PERIOD_24HOUR = 86400;
    private final KmsClient kmsClient;

    public DuibaConsumerCookieClient(RemoteKmsService remoteKmsService) {
        this.kmsClient = new KmsClient(remoteKmsService);
    }

    public ConsumerCookieDto getConsumerCookieDto(HttpServletRequest request) {
        String wdata4 = RequestTool.getCookie((HttpServletRequest)request, (String)CONSUMER_WDATA4_COOKIE);
        if (wdata4 == null || wdata4.isEmpty()) {
            return null;
        }
        long ts = NumberUtils.parseLong((String)RequestTool.getCookie((HttpServletRequest)request, (String)LOGIN_TIME_COOKIE), (long)-1L);
        if (ts == -1L || !this.isValidTime(ts)) {
            return null;
        }
        TimeBasedRollingKeyDto tbrk = this.getTimeBasedRollingKey(ts);
        String userJson = this.kmsClient.decrypt(wdata4, tbrk);
        ConsumerCookieDto c = (ConsumerCookieDto)JSONObject.parseObject((String)userJson, ConsumerCookieDto.class);
        if (!this.isValidTime(c.getTime())) {
            return null;
        }
        return c;
    }

    public ConsumerCookieDto getLzljConsumerCookieDto(HttpServletRequest request) {
        String lzljInfo = RequestTool.getCookie((HttpServletRequest)request, (String)COMMERCIAL_LZLJ_INFO_COOKIE);
        if (lzljInfo == null || lzljInfo.isEmpty()) {
            return null;
        }
        long ts = NumberUtils.parseLong((String)RequestTool.getCookie((HttpServletRequest)request, (String)LOGIN_TIME_COOKIE), (long)-1L);
        if (ts == -1L || !this.isValidTime(ts)) {
            return null;
        }
        TimeBasedRollingKeyDto tbrk = this.getTimeBasedRollingKey(ts);
        String userJson = this.kmsClient.decrypt(lzljInfo, tbrk);
        ConsumerCookieDto c = (ConsumerCookieDto)JSONObject.parseObject((String)userJson, ConsumerCookieDto.class);
        if (!this.isValidTime(c.getTime())) {
            return null;
        }
        return c;
    }

    public ConsumerCookieDto getConsumerCookieDtoForYjq(HttpServletRequest request) {
        String yjqInfo = RequestTool.getCookie((HttpServletRequest)request, (String)CONSUMER_YJQ_INFO_COOKIE);
        if (yjqInfo == null || yjqInfo.isEmpty()) {
            return null;
        }
        long ts = NumberUtils.parseLong((String)RequestTool.getCookie((HttpServletRequest)request, (String)YJQ_LOGIN_TIME_COOKIE), (long)-1L);
        if (ts == -1L || !this.isValidTime(ts)) {
            return null;
        }
        TimeBasedRollingKeyDto tbrk = this.getTimeBasedRollingKey(ts);
        String userJson = this.kmsClient.decrypt(yjqInfo, tbrk);
        ConsumerCookieDto c = (ConsumerCookieDto)JSONObject.parseObject((String)userJson, ConsumerCookieDto.class);
        if (!this.isValidTime(c.getTime())) {
            return null;
        }
        return c;
    }

    public ConsumerCookieDto injectConsumerInfoIntoCookie(ConsumerDto consumer, HttpServletRequest request, HttpServletResponse response, String cookieDomain, String oldConsumerEncryptKey, boolean isFromCommercial) {
        String userCookieVal;
        long loginTime = System.currentTimeMillis();
        ConsumerCookieDto cookieDto = this.makeConsumerCookieDto(consumer, loginTime);
        if (isFromCommercial) {
            cookieDto.setForEver(true);
        }
        String userJson = JSONObject.toJSONString((Object)cookieDto);
        if (isFromCommercial) {
            userCookieVal = BlowfishUtils.encryptBlowfish((String)userJson, (String)oldConsumerEncryptKey);
        } else {
            TimeBasedRollingKeyDto tbrk = this.getTimeBasedRollingKey(loginTime);
            userCookieVal = this.kmsClient.encrypt(userJson, tbrk);
        }
        String reqDomain = this.getRequestDomain(request, cookieDomain);
        if (reqDomain != null) {
            Cookie reqUserCookie = new Cookie(isFromCommercial ? COMMERCIAL_CONSUMER_WDATA3_COOKIE : CONSUMER_WDATA4_COOKIE, userCookieVal);
            reqUserCookie.setHttpOnly(true);
            reqUserCookie.setDomain(reqDomain);
            reqUserCookie.setPath("/");
            if (isFromCommercial) {
                reqUserCookie.setMaxAge(315360000);
            } else {
                reqUserCookie.setMaxAge(86400);
            }
            response.addCookie(reqUserCookie);
        } else {
            Cookie userCookie = new Cookie(isFromCommercial ? COMMERCIAL_CONSUMER_WDATA3_COOKIE : CONSUMER_WDATA4_COOKIE, userCookieVal);
            userCookie.setHttpOnly(true);
            userCookie.setDomain(cookieDomain);
            userCookie.setPath("/");
            if (isFromCommercial) {
                userCookie.setMaxAge(315360000);
            } else {
                userCookie.setMaxAge(86400);
            }
            response.addCookie(userCookie);
        }
        String loginTimeStr = String.valueOf(loginTime);
        if (reqDomain != null) {
            Cookie reqTsCookie = new Cookie(LOGIN_TIME_COOKIE, loginTimeStr);
            reqTsCookie.setHttpOnly(true);
            reqTsCookie.setDomain(reqDomain);
            reqTsCookie.setPath("/");
            if (isFromCommercial) {
                reqTsCookie.setValue("");
                reqTsCookie.setMaxAge(0);
            } else {
                reqTsCookie.setMaxAge(86400);
            }
            response.addCookie(reqTsCookie);
        } else {
            Cookie tsCookie = new Cookie(LOGIN_TIME_COOKIE, loginTimeStr);
            tsCookie.setHttpOnly(true);
            tsCookie.setDomain(cookieDomain);
            tsCookie.setPath("/");
            if (isFromCommercial) {
                tsCookie.setValue("");
                tsCookie.setMaxAge(0);
            }
            response.addCookie(tsCookie);
        }
        JSONObject aidCidObject = new JSONObject();
        aidCidObject.put("aid", (Object)consumer.getAppId());
        aidCidObject.put("cid", (Object)consumer.getId());
        String aidCidValue = SecurityUtils.encode2StringByBase64((byte[])aidCidObject.toJSONString().getBytes());
        if (reqDomain != null) {
            Cookie reqAcCookie = new Cookie("_ac", aidCidValue);
            reqAcCookie.setHttpOnly(true);
            reqAcCookie.setDomain(reqDomain);
            reqAcCookie.setPath("/");
            if (isFromCommercial) {
                reqAcCookie.setMaxAge(315360000);
            }
            response.addCookie(reqAcCookie);
        } else {
            Cookie acCookie = new Cookie("_ac", aidCidValue);
            acCookie.setHttpOnly(true);
            acCookie.setDomain(cookieDomain);
            acCookie.setPath("/");
            if (isFromCommercial) {
                acCookie.setMaxAge(315360000);
            }
            response.addCookie(acCookie);
        }
        String tokenId = SecurityUtils.encode2StringByMd5((String)userCookieVal);
        if (reqDomain != null) {
            Cookie reqTokenIdCookie = new Cookie(TOKEN_ID_COOKIE, tokenId);
            reqTokenIdCookie.setDomain(reqDomain);
            reqTokenIdCookie.setPath("/");
            if (isFromCommercial) {
                reqTokenIdCookie.setMaxAge(315360000);
            }
            response.addCookie(reqTokenIdCookie);
        } else {
            Cookie tokenIdCookie = new Cookie(TOKEN_ID_COOKIE, tokenId);
            tokenIdCookie.setDomain(cookieDomain);
            tokenIdCookie.setPath("/");
            if (isFromCommercial) {
                tokenIdCookie.setMaxAge(315360000);
            }
            response.addCookie(tokenIdCookie);
        }
        request.setAttribute("c_tokenId", (Object)tokenId);
        if (!isFromCommercial) {
            if (reqDomain != null) {
                this.injectOldWdata3Cookie(userJson, response, reqDomain, oldConsumerEncryptKey);
            } else {
                this.injectOldWdata3Cookie(userJson, response, cookieDomain, oldConsumerEncryptKey);
            }
        }
        return cookieDto;
    }

    public ConsumerCookieDto injectConsumerInfoIntoCookie(ConsumerDto consumer, HttpServletRequest request, HttpServletResponse response, String cookieDomain, String oldConsumerEncryptKey, boolean isFromCommercial, Integer isMultiApp) {
        Cookie userCookie;
        Cookie reqUserCookie;
        String userCookieVal;
        long loginTime = System.currentTimeMillis();
        ConsumerCookieDto cookieDto = this.makeConsumerCookieDto(consumer, loginTime);
        if (isFromCommercial) {
            cookieDto.setForEver(true);
        }
        String userJson = JSONObject.toJSONString((Object)cookieDto);
        if (isFromCommercial) {
            userCookieVal = BlowfishUtils.encryptBlowfish((String)userJson, (String)oldConsumerEncryptKey);
        } else {
            TimeBasedRollingKeyDto tbrk = this.getTimeBasedRollingKey(loginTime);
            userCookieVal = this.kmsClient.encrypt(userJson, tbrk);
        }
        String reqDomain = this.getRequestDomain(request, cookieDomain);
        if (reqDomain != null) {
            reqUserCookie = new Cookie(isFromCommercial ? COMMERCIAL_CONSUMER_WDATA3_COOKIE : CONSUMER_WDATA4_COOKIE, userCookieVal);
            reqUserCookie.setHttpOnly(true);
            reqUserCookie.setDomain(reqDomain);
            reqUserCookie.setPath("/");
            if (isFromCommercial) {
                reqUserCookie.setMaxAge(315360000);
            } else {
                reqUserCookie.setMaxAge(86400);
            }
            response.addCookie(reqUserCookie);
        } else {
            userCookie = new Cookie(isFromCommercial ? COMMERCIAL_CONSUMER_WDATA3_COOKIE : CONSUMER_WDATA4_COOKIE, userCookieVal);
            userCookie.setHttpOnly(true);
            userCookie.setDomain(cookieDomain);
            userCookie.setPath("/");
            if (isFromCommercial) {
                userCookie.setMaxAge(315360000);
            } else {
                userCookie.setMaxAge(86400);
            }
            response.addCookie(userCookie);
        }
        if (isMultiApp == 1) {
            if (reqDomain != null) {
                reqUserCookie = new Cookie(COMMERCIAL_LZLJ_INFO_COOKIE, userCookieVal);
                reqUserCookie.setHttpOnly(true);
                reqUserCookie.setDomain(reqDomain);
                reqUserCookie.setPath("/");
                reqUserCookie.setMaxAge(86400);
                response.addCookie(reqUserCookie);
            } else {
                userCookie = new Cookie(COMMERCIAL_LZLJ_INFO_COOKIE, userCookieVal);
                userCookie.setHttpOnly(true);
                userCookie.setDomain(cookieDomain);
                userCookie.setPath("/");
                userCookie.setMaxAge(86400);
                response.addCookie(userCookie);
            }
        }
        String loginTimeStr = String.valueOf(loginTime);
        if (reqDomain != null) {
            Cookie reqTsCookie = new Cookie(LOGIN_TIME_COOKIE, loginTimeStr);
            reqTsCookie.setHttpOnly(true);
            reqTsCookie.setDomain(reqDomain);
            reqTsCookie.setPath("/");
            if (isFromCommercial) {
                reqTsCookie.setValue("");
                reqTsCookie.setMaxAge(0);
            } else {
                reqTsCookie.setMaxAge(86400);
            }
            response.addCookie(reqTsCookie);
        } else {
            Cookie tsCookie = new Cookie(LOGIN_TIME_COOKIE, loginTimeStr);
            tsCookie.setHttpOnly(true);
            tsCookie.setDomain(cookieDomain);
            tsCookie.setPath("/");
            if (isFromCommercial) {
                tsCookie.setValue("");
                tsCookie.setMaxAge(0);
            }
            response.addCookie(tsCookie);
        }
        JSONObject aidCidObject = new JSONObject();
        aidCidObject.put("aid", (Object)consumer.getAppId());
        aidCidObject.put("cid", (Object)consumer.getId());
        String aidCidValue = SecurityUtils.encode2StringByBase64((byte[])aidCidObject.toJSONString().getBytes());
        if (reqDomain != null) {
            Cookie reqAcCookie = new Cookie("_ac", aidCidValue);
            reqAcCookie.setHttpOnly(true);
            reqAcCookie.setDomain(reqDomain);
            reqAcCookie.setPath("/");
            if (isFromCommercial) {
                reqAcCookie.setMaxAge(315360000);
            }
            response.addCookie(reqAcCookie);
        } else {
            Cookie acCookie = new Cookie("_ac", aidCidValue);
            acCookie.setHttpOnly(true);
            acCookie.setDomain(cookieDomain);
            acCookie.setPath("/");
            if (isFromCommercial) {
                acCookie.setMaxAge(315360000);
            }
            response.addCookie(acCookie);
        }
        String tokenId = SecurityUtils.encode2StringByMd5((String)userCookieVal);
        if (reqDomain != null) {
            Cookie reqTokenIdCookie = new Cookie(TOKEN_ID_COOKIE, tokenId);
            reqTokenIdCookie.setDomain(reqDomain);
            reqTokenIdCookie.setPath("/");
            if (isFromCommercial) {
                reqTokenIdCookie.setMaxAge(315360000);
            }
            response.addCookie(reqTokenIdCookie);
        } else {
            Cookie tokenIdCookie = new Cookie(TOKEN_ID_COOKIE, tokenId);
            tokenIdCookie.setDomain(cookieDomain);
            tokenIdCookie.setPath("/");
            if (isFromCommercial) {
                tokenIdCookie.setMaxAge(315360000);
            }
            response.addCookie(tokenIdCookie);
        }
        request.setAttribute("c_tokenId", (Object)tokenId);
        if (!isFromCommercial) {
            if (reqDomain != null) {
                this.injectOldWdata3Cookie(userJson, response, reqDomain, oldConsumerEncryptKey);
            } else {
                this.injectOldWdata3Cookie(userJson, response, cookieDomain, oldConsumerEncryptKey);
            }
        }
        return cookieDto;
    }

    public String getRequestDomain(HttpServletRequest request, String cookieDomain) {
        String domainName = request.getServerName();
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(X_HOST))) {
            return request.getHeader(X_HOST);
        }
        if (domainName == null || "".equals(domainName)) {
            return null;
        }
        if (domainName.contains(cookieDomain)) {
            return null;
        }
        if (domainName.contains("dexfu.cn")) {
            return "dexfu.cn";
        }
        if (domainName.contains("dbsa14.cn")) {
            return "dbsa14.cn";
        }
        return domainName;
    }

    @Deprecated
    private void injectOldWdata3Cookie(String userJson, HttpServletResponse response, String cookieDomain, String oldConsumerEncryptKey) {
        String wdata3 = BlowfishUtils.encryptBlowfish((String)userJson, (String)oldConsumerEncryptKey);
        Cookie wdata3Cookie = new Cookie(COMMERCIAL_CONSUMER_WDATA3_COOKIE, wdata3);
        wdata3Cookie.setDomain(cookieDomain);
        wdata3Cookie.setPath("/");
        response.addCookie(wdata3Cookie);
    }

    private boolean isValidTime(long loginTime) {
        long now = System.currentTimeMillis();
        return loginTime > now - 86400000L && loginTime < now + 300000L;
    }

    private TimeBasedRollingKeyDto getTimeBasedRollingKey(long ts) {
        return this.kmsClient.getCachedTimeBasedRollingKey(KeyUseTypeEnums.COOKIE, KeyTypeEnums.AES_128, ts);
    }

    private ConsumerCookieDto makeConsumerCookieDto(ConsumerDto consumerDto, long loginTime) {
        if (consumerDto.getAppId() == null) {
            throw new IllegalArgumentException("consumer's appId must not be null");
        }
        if (consumerDto.getId() == null) {
            throw new IllegalArgumentException("consumer's id must not be null");
        }
        if (consumerDto.getPartnerUserId() == null) {
            throw new IllegalArgumentException("consumer's partnerUserId must not be null");
        }
        ConsumerCookieDto cookieDto = new ConsumerCookieDto();
        cookieDto.setAppId(consumerDto.getAppId());
        cookieDto.setCid(consumerDto.getId());
        cookieDto.setPartnerUserId(consumerDto.getPartnerUserId());
        cookieDto.setTime(loginTime);
        return cookieDto;
    }

    public ConsumerCookieDto injectConsumerInfoIntoCookieForYjq(ConsumerDto consumer, HttpServletRequest request, HttpServletResponse response, String cookieDomain, String oldConsumerEncryptKey) {
        long loginTime = System.currentTimeMillis();
        ConsumerCookieDto cookieDto = this.makeConsumerCookieDto(consumer, loginTime);
        String userJson = JSONObject.toJSONString((Object)cookieDto);
        TimeBasedRollingKeyDto tbrk = this.getTimeBasedRollingKey(loginTime);
        String userCookieVal = this.kmsClient.encrypt(userJson, tbrk);
        String reqDomain = this.getRequestDomain(request, cookieDomain);
        if (reqDomain != null) {
            Cookie reqUserCookie = new Cookie(CONSUMER_YJQ_INFO_COOKIE, userCookieVal);
            reqUserCookie.setHttpOnly(true);
            reqUserCookie.setDomain(reqDomain);
            reqUserCookie.setPath("/");
            response.addCookie(reqUserCookie);
        } else {
            Cookie userCookie = new Cookie(CONSUMER_YJQ_INFO_COOKIE, userCookieVal);
            userCookie.setHttpOnly(true);
            userCookie.setDomain(cookieDomain);
            userCookie.setPath("/");
            response.addCookie(userCookie);
        }
        String loginTimeStr = String.valueOf(loginTime);
        if (reqDomain != null) {
            Cookie reqTsCookie = new Cookie(YJQ_LOGIN_TIME_COOKIE, loginTimeStr);
            reqTsCookie.setHttpOnly(true);
            reqTsCookie.setDomain(reqDomain);
            reqTsCookie.setPath("/");
            response.addCookie(reqTsCookie);
        } else {
            Cookie tsCookie = new Cookie(YJQ_LOGIN_TIME_COOKIE, loginTimeStr);
            tsCookie.setHttpOnly(true);
            tsCookie.setDomain(cookieDomain);
            tsCookie.setPath("/");
            response.addCookie(tsCookie);
        }
        return cookieDto;
    }
}

