/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.basic;

import java.util.Date;
import java.util.List;
import org.springframework.data.redis.core.StringRedisTemplate;

public class BitMapUtil {
    public static Long bitCount(StringRedisTemplate stringRedisTemplate, String filterKey) {
        return (Long)stringRedisTemplate.execute(connection -> connection.bitCount(filterKey.getBytes()));
    }

    public static boolean mightContainWithPipeline(StringRedisTemplate stringRedisTemplate, String filterKey, int[] offset) {
        List objects = stringRedisTemplate.executePipelined(connection -> {
            byte[] rawKey = BitMapUtil.getBytes(stringRedisTemplate, filterKey);
            for (int i : offset) {
                connection.getBit(rawKey, (long)i);
            }
            return null;
        });
        for (Object object : objects) {
            if (((Boolean)object).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void putWithPipeline(StringRedisTemplate stringRedisTemplate, String filterKey, int[] offset, Date expireAt) {
        stringRedisTemplate.executePipelined(connection -> {
            byte[] rawKey = BitMapUtil.getBytes(stringRedisTemplate, filterKey);
            for (int i : offset) {
                connection.setBit(rawKey, (long)i, true);
            }
            if (expireAt != null) {
                connection.expireAt(rawKey, expireAt.getTime() / 1000L);
            }
            return null;
        });
    }

    private static byte[] getBytes(StringRedisTemplate stringRedisTemplate, String filterKey) {
        return stringRedisTemplate.getKeySerializer().serialize((Object)filterKey);
    }
}

