/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.daily.DailyRedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.path.PathParser;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UrlSerialAccessFilter {
    public static final Logger LOGGER = LoggerFactory.getLogger(UrlSerialAccessFilter.class);
    private final DailyRedisBloomFilter dailyRedisBloomFilter;

    public UrlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        this.dailyRedisBloomFilter = dailyRedisBloomFilter;
    }

    private static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    private static String generateValue(Long cid, String path) {
        return cid + "_" + path;
    }

    public void record(PathParser pathParser, Long cid) {
        if (pathParser == null || cid == null || cid <= 0L) {
            return;
        }
        String path = pathParser.getPath();
        try {
            String key = pathParser.getParser().parse(UrlSerialAccessFilter.getHttpServletRequest());
            String value = UrlSerialAccessFilter.generateValue(cid, path);
            this.dailyRedisBloomFilter.put(key, value);
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception,cid={},path={}", new Object[]{cid, path, e});
        }
    }

    public Pair<Boolean, String> hasRecord(PathParser pathParser, Long cid, String targetPath) {
        Pair pair = Pair.from((Object)true, null);
        if (pathParser == null || cid == null || cid <= 0L) {
            return pair;
        }
        String path = pathParser.getPath();
        try {
            String key = pathParser.getParser().parse(UrlSerialAccessFilter.getHttpServletRequest());
            String value = UrlSerialAccessFilter.generateValue(cid, targetPath);
            Pair<Boolean, String> mightContain = this.dailyRedisBloomFilter.mightContain(key, value);
            return Pair.from((Object)mightContain.getKey(), (Object)path);
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,findFromRecords,exception,cid={},path={}", new Object[]{cid, path, e});
            return pair;
        }
    }
}

