package cn.com.duiba.boot.utils;

import org.springframework.context.ConfigurableApplicationContext;

/**
 * Created by gyf .
 * 2018/3/29 .
 */
public final class MainApplicationContextHolder {
    private MainApplicationContextHolder(){}

    private static volatile ConfigurableApplicationContext applicationContext;

    /**
     * 外部方法禁止调用此方法
     * @param applicationContext
     */
    public static void _setApplicationContext(ConfigurableApplicationContext applicationContext) {
        if(MainApplicationContextHolder.applicationContext != null &&
                MainApplicationContextHolder.applicationContext.isActive()){
            throw new IllegalStateException("外部方法禁止调用_setApplicationContext");
        }
        MainApplicationContextHolder.applicationContext = applicationContext;
    }

    /**
     * 获取当前应用的applicationContext
     * @return
     */
    public static ConfigurableApplicationContext getApplicationContext() {
        return applicationContext;
    }
}
