package cn.com.duiba.boot.perftest;

import lombok.Getter;

/**
 * 压测场景ID携带类
 */
@Getter
public final class PerfTestDto {
    public static final String PERF_TEST_DTO_KEY = "perfTestDto";
    /**
     * 压测场景ID
     */
    private final String perfTestSceneId;

    private final boolean isTestCluster;

    public PerfTestDto(String perfTestSceneId, boolean isTestCluster) {
        this.perfTestSceneId = perfTestSceneId;
        this.isTestCluster = isTestCluster;
    }

    public boolean isTestCluster() {
        return isTestCluster && (perfTestSceneId != null);
    }

    /**
     * 判断压测请求的场景id和服务器的场景id是否相同。
     * 如果都为null，则认为不同
     * @param serverPerfSceneId
     * @return
     */
    public boolean sceneIdEquals(String serverPerfSceneId) {
        if (perfTestSceneId == null || serverPerfSceneId == null) {
            return false;
        }
        return perfTestSceneId.equals(serverPerfSceneId);
    }

    @Override
    public String toString() {
        return "PerfTestDto{" +
                "perfTestSceneId='" + perfTestSceneId + '\'' +
                '}';
    }

}
