package cn.com.duiba.boot.hazelcast;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.Ordered;

/**
 * Created by guoyanfei .
 * 2022/3/22 .
 */
public abstract class EurekaHazelcastGroupKey implements Ordered {

    private static final String SEPARATOR = "-";

    /**
     * 用于表示分组key的实际内容，比如压测场景id，多场景场景id
     */
    private final String factor;

    public EurekaHazelcastGroupKey(String factor) {
        this.factor = factor;
    }

    /**
     * key的前缀，比如压测 Perf
     *
     * @return
     */
    public abstract String prefix();

    public String getKey() {
        if (StringUtils.isBlank(this.factor)) {
            return null;
        }
        return prefix() + SEPARATOR + this.factor;
    }

}
