package cn.com.duiba.boot.perftest;

/**
 * 常量
 * Created by guoyanfei .
 * 2022/2/18 .
 */
public class PerfTestConstant {

    private PerfTestConstant() {
    }

    /**
     * Cookie/Header/Param 中包含这个key，就表示是压测流量，value值是压测场景id
     */
    public static final String PERF_TEST_SCENE_ID_REQUEST_KEY = "duibaNewPerfSceneId";

    /**
     * 压测场景id注册到eureka的metadata中的key
     */
    public static final String PERF_TEST_SCENE_ID_EUREKA_KEY = "duiba.new.perf.scene.id";

    /**
     * 压测场景id注册到eureka的metadata中的key，老版本
     */
    public static final String PERF_TEST_SCENE_ID_EUREKA_KEY_OLD = "duiba.perf.scene.id";

    /**
     * 压测场景id注册到dubbo的parameter中的key
     */
    public static final String PERF_TEST_SCENE_ID_DUBBO_KEY = "duibaNewPerfSceneId";

    /**
     * 压测场景id在环境变量中的key
     */
    public static final String PERF_TEST_SCENE_ID_ENV_KEY = "DUIBA_NEW_PERF_SCENE_ID";

    /**
     * 支持压测的标记，注册到zk和eureka中，兼容老的逻辑
     */
    public static final String IS_PERF_TEST_SUPPORTTED_KEY_OLD = "isPerfTestSupportted";

    /**
     * 压测相关的scheme前缀
     */
    public static final String TEST_SCHEME_PREFIX = "perf__";

    /**
     * rocketmq相关配置key
     */
    public static final String ROCKETMQ_NAMESRV_PROP_KEY          = "duiba.rocketmq.nameSrvAddr";
    public static final String ROCKETMQ_NAMESRV_PROP_PERF_KEY     = "duiba.rocketmq.nameSrvAddrPerf";
    public static final String ROCKETMQ_NAMESRV_PROP_KEY_NEW      = "rocketmq.name-server";
    public static final String ROCKETMQ_NAMESRV_PROP_PERF_KEY_NEW = "rocketmq.name-server-perf";

}
