package cn.com.duiba.boot.perftest;

import org.apache.commons.lang3.StringUtils;

/**
 * 压测工具类
 * Created by guoyanfei .
 * 2022/2/18 .
 */
public class PerfTestUtils {

    private static final String PERF_TEST_SCENE_ID_IN_ENV = StringUtils.trimToNull(System.getenv(PerfTestConstant.PERF_TEST_SCENE_ID_ENV_KEY));

    private PerfTestUtils() {
    }

    /**
     * 判断当前是不是压测机器
     * 环境变量压测场景id不为空，就是压测机器
     *
     * @param request
     * @return
     */
    public static boolean isPerfTestEnv() {
        return StringUtils.isNotBlank(PERF_TEST_SCENE_ID_IN_ENV);
    }

    /**
     * 从环境变量中获取压测场景id
     *
     * @param request
     * @return 压测场景id，可能为null
     */
    public static String getSceneId() {
        return PERF_TEST_SCENE_ID_IN_ENV;
    }
}
