package cn.com.duiba.boot.grouping;

import brave.baggage.BaggageField;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * 服务分组标识获取的工具类
 * 目前用于支持需求：http://cf.dui88.com/pages/viewpage.action?pageId=11134823
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
public final class ServiceGroupUtils {

    private ServiceGroupUtils() {
    }

    public static final String DUIBA_SERVICE_GROUP_KEY = "_duibaServiceGroupKey";
    //开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
    public static final String DUIBA_SERVICE_GROUP_IP_PREFIX = "dev_ip_";

    // 环境变量中服务分组的key
    public static final String ENV_DUIBA_SERVICE_GROUP_KEY = "DUIBA_SERVICE_GROUP_KEY";

    /**
     * 从sleuth中获取 _duibaServiceGroupKey
     *
     * @return
     */
    public static String getCurrentGroupKey() {
        String groupKey = null;
        BaggageField field = BaggageField.getByName(DUIBA_SERVICE_GROUP_KEY);
        if (field != null) {
            groupKey = field.getValue();
        }
        return groupKey;
    }

    /**
     * 设置服务分组值（框架调用者，非必要不要调用）
     *
     * @param value
     */
    public static void setGroupKey(String value) {
        BaggageField field = BaggageField.getByName(DUIBA_SERVICE_GROUP_KEY);
        if (field != null && StringUtils.isEmpty(field.getValue())) {
            field.updateValue(value);
        }
    }
}
