package cn.com.duiba.boot.ext.autoconfigure.logger;

/**
 * 日志接口 声明
 * @author xugf create by 2016-12-01
 *
 */
public interface DuiBaLogger {
	/**
	 * 当前级别是否支持debug日志输出
	 * @return
	 */
	public boolean isDebugEnabled();
	
	/**
	 * 当前级别是否支持info日志输出
	 * @return
	 */
	public boolean isInfoEnabled();
	
	/**
	 * 当前级别是否支持warn日志输出
	 * @return
	 */
	public boolean isWarnEnabled();
	
	/**
	 * 当前级别是否支持error日志输出
	 * @return
	 */
	public boolean isErrorEnabled();

	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void debug(String message);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void debug(String message, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void debug(Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void debugTag(String message, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void debugTag(String message, String keyword, Object... args);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void debug(String message, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void debug(String message, Throwable exception, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void debug(Throwable exception, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void debug(String message, String keyword, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void debug(String message, String keyword, Throwable exception, Object... args);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void info(String message);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void info(String message, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void info(Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void infoTag(String message, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void infoTag(String message, String keyword, Object... args);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void info(String message, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void info(String message, Throwable exception, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void info(Throwable exception, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void info(String message, String keyword, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void info(String message, String keyword, Throwable exception, Object... args);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void warn(String message);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void warn(String message, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void warn(Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void warnTag(String message, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void warnTag(String message, String keyword, Object... args);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void warn(String message, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void warn(String message, Throwable exception, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void warn(Throwable exception, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void warn(String message, String keyword, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void warn(String message, String keyword, Throwable exception, Object... args);

	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void error(String message);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void error(String message, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void error(Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void errorTag(String message, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void errorTag(String message, String keyword, Object... args);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void error(String message, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void error(String message, Throwable exception, Object... args);
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void error(Throwable exception, String keyword);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void error(String message, String keyword, Throwable exception);
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void error(String message, String keyword, Throwable exception, Object... args);
}
