package cn.com.duiba.boot.ext.autoconfigure.logger;

import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

/**
 * @author xugf create by 2016-11-30
 */
public class DuibaLoggerImpl implements DuiBaLogger{
	private PrintLogger printLogger;
	private Logger logger;
	
	public DuibaLoggerImpl(String className){
		printLogger = new PrintLogger(className);
		logger = printLogger.getLoggerInstance();
	}
	
	/**
	 * 当前级别是否支持debug日志输出
	 * @return
	 */
	public boolean isDebugEnabled(){
		return logger.isDebugEnabled();
	}
	
	/**
	 * 当前级别是否支持info日志输出
	 * @return
	 */
	public boolean isInfoEnabled(){
		return logger.isInfoEnabled();
	}
	
	/**
	 * 当前级别是否支持warn日志输出
	 * @return
	 */
	public boolean isWarnEnabled(){
		return logger.isWarnEnabled();
	}
	
	/**
	 * 当前级别是否支持error日志输出
	 * @return
	 */
	public boolean isErrorEnabled(){
		return logger.isErrorEnabled();
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void debug(String message){
		printLogger.log(message, "debug", "", null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void debug(String message, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "debug", "", null);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void debug(Throwable exception){
		printLogger.log("", "debug", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void debugTag(String message, String keyword){
		printLogger.log(message, "debug", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void debugTag(String message, String keyword, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "debug", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void debug(String message, Throwable exception){
		printLogger.log(message, "debug", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void debug(String message, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "debug", "", exception);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void debug(Throwable exception, String keyword){
		printLogger.log("", "debug", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void debug(String message, String keyword, Throwable exception){
		printLogger.log(message, "debug", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void debug(String message, String keyword, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "debug", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void info(String message){
		printLogger.log(message, "info", "", null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void info(String message, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "info", "", null);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void info(Throwable exception){
		printLogger.log("", "info", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void infoTag(String message, String keyword){
		printLogger.log(message, "info", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void infoTag(String message, String keyword, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "info", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void info(String message, Throwable exception){
		printLogger.log(message, "info", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void info(String message, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "info", "", exception);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void info(Throwable exception, String keyword){
		printLogger.log("", "info", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void info(String message, String keyword, Throwable exception){
		printLogger.log(message, "info", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void info(String message, String keyword, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "info", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void warn(String message){
		printLogger.log(message, "warn", "", null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void warn(String message, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "warn", "", null);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void warn(Throwable exception){
		printLogger.log("", "warn", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void warnTag(String message, String keyword){
		printLogger.log(message, "warn", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void warnTag(String message, String keyword, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "warn", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void warn(String message, Throwable exception){
		printLogger.log(message, "warn", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void warn(String message, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "warn", "", exception);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void warn(Throwable exception, String keyword){
		printLogger.log("", "warn", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void warn(String message, String keyword, Throwable exception){
		printLogger.log(message, "warn", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void warn(String message, String keyword, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "warn", keyword, exception);
	}

	/**
	 * 
	 * @param message 需要输出的日志内容
	 */
	public void error(String message){
		printLogger.log(message, "error", "", null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param args 占位符替换参数
	 */
	public void error(String message, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "error", "", null);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 */
	public void error(Throwable exception){
		printLogger.log("", "error", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void errorTag(String message, String keyword){
		printLogger.log(message, "error", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param args 占位符替换参数
	 */
	public void errorTag(String message, String keyword, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "error", keyword, null);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 */
	public void error(String message, Throwable exception){
		printLogger.log(message, "error", "", exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void error(String message, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "error", "", exception);
	}
	
	/**
	 * 
	 * @param exception 异常信息
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 */
	public void error(Throwable exception, String keyword){
		printLogger.log("", "error", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 */
	public void error(String message, String keyword, Throwable exception){
		printLogger.log(message, "error", keyword, exception);
	}
	
	/**
	 * 
	 * @param message 需要输出的日志内容
	 * @param keyword 信息关键字 tag值，可以作为后续日志分析使用
	 * @param exception 异常信息
	 * @param args 占位符替换参数
	 */
	public void error(String message, String keyword, Throwable exception, Object... args){
		message = MessageFormatter.arrayFormat(message, args).getMessage();
		printLogger.log(message, "error", keyword, exception);
	}
}
