package cn.com.duiba.boot.ext.autoconfigure.logger;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;

/**
 * @author xugf create by 2016-11-30
 */
public class PrintLogger {
	private static final Logger logger = LoggerFactory.getLogger("loginsight_log");
	private String className;
	
	public PrintLogger(String className){
		this.className = className;
	}
	
	public Logger getLoggerInstance(){
		return logger;
	}

	public void log(String message, String logLevel, String keyword, Throwable exception){
		MessageLogInfo messageLogInfo = new MessageLogInfo(className);
		messageLogInfo.setLogLevel(logLevel);
		if(StringUtils.isNotBlank(message)){
			messageLogInfo.setMessage(message);
		}
		if(StringUtils.isNotBlank(keyword)){
			messageLogInfo.setKeyword(keyword);
		}
		if(exception != null){
			messageLogInfo.setErrorType(exception.getClass().getName());
			messageLogInfo.setErrorMessage(exception.getMessage());
			messageLogInfo.setException(getExceptionStr(exception));
		}
		if("debug".equals(logLevel)){
			logger.debug(JSON.toJSONString(messageLogInfo));
		}else if("info".equals(logLevel)){
			logger.info(JSON.toJSONString(messageLogInfo));
		}else if("warn".equals(logLevel)){
			logger.warn(JSON.toJSONString(messageLogInfo));
		}else if("error".equals(logLevel)){
			logger.error(JSON.toJSONString(messageLogInfo));
		}
	}
	
	public String getExceptionStr(Throwable exception){
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		try {
			exception.printStackTrace(pw);
			return sw.toString();
		} finally{
			pw.close();
		}
	}
}
