/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.logger;

import cn.com.duiba.boot.ext.autoconfigure.logger.MessageLogInfo;
import com.alibaba.fastjson.JSON;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintLogger {
    private static final Logger logger = LoggerFactory.getLogger((String)"loginsight_log");
    private String className;

    public PrintLogger(String className) {
        this.className = className;
    }

    public Logger getLoggerInstance() {
        return logger;
    }

    public void log(String message, String logLevel, String keyword, Throwable exception) {
        MessageLogInfo messageLogInfo = new MessageLogInfo(this.className);
        messageLogInfo.setLogLevel(logLevel);
        if (StringUtils.isNotBlank((String)message)) {
            messageLogInfo.setMessage(message);
        }
        if (StringUtils.isNotBlank((String)keyword)) {
            messageLogInfo.setKeyword(keyword);
        }
        if (exception != null) {
            messageLogInfo.setErrorType(exception.getClass().getName());
            messageLogInfo.setErrorMessage(exception.getMessage());
            messageLogInfo.setException(this.getExceptionStr(exception));
        }
        if ("debug".equals(logLevel)) {
            logger.debug(JSON.toJSONString((Object)messageLogInfo));
        } else if ("info".equals(logLevel)) {
            logger.info(JSON.toJSONString((Object)messageLogInfo));
        } else if ("warn".equals(logLevel)) {
            logger.warn(JSON.toJSONString((Object)messageLogInfo));
        } else if ("error".equals(logLevel)) {
            logger.error(JSON.toJSONString((Object)messageLogInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionStr(Throwable exception) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }
}

