package cn.com.duiba.boot.ext.autoconfigure.dpm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Url Filter
 * 判断如果参数中包含dpm,则认为是一个dpm埋点url,提取相应参数进行json格式日志输出
 * Created by xuhengfei on 16/12/20.
 */
public class DpmFilter implements Filter{


    private Logger LOG= LoggerFactory.getLogger(DpmFilter.class);

    private Logger DPM_LOG=LoggerFactory.getLogger("dpm_log");

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {

        try {
            HttpServletRequest req = (HttpServletRequest) servletRequest;
            String dpm = req.getParameter("dpm");
            if (dpm != null && !"".equals(dpm.trim())) {
                DpmLog log = new DpmLog();
                log.setDpm(dpm);

                String dpmType=req.getParameter("dpmType");
                if(dpmType==null){
                    log.setDpmType(DpmTypeClick);
                }else{
                    log.setDpmType(Integer.valueOf(dpmType));
                }

                Cookie[] cookies = req.getCookies();
                Map<String, Cookie> cookieMap = new HashMap<>();
                for (Cookie c : cookies) {
                    cookieMap.put(c.getName(), c);
                }

                Cookie _ac = cookieMap.get("_ac");
                if (_ac != null){//优先从cookie取数据
                    String json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()),"utf-8");
                    JSONObject object = JSONObject.parseObject(json);
                    log.setAppId(object.getLong("aid"));
                    log.setConsumerId(object.getLong("cid"));
                }else{//如果cookie中没有数据,则尝试从url参数中取数据
                    String appId=req.getParameter("appId");
                    if(appId!=null){
                        log.setAppId(Long.valueOf(appId));
                    }
                    String consumerId=req.getParameter("consumerId");
                    if(consumerId!=null){
                        log.setConsumerId(Long.valueOf(consumerId));
                    }
                }

                log.setRefererDpm(req.getParameter("referer_dpm"));

                String url = "http://" + req.getServerName() //服务器地址
                        + req.getContextPath()      //项目名称
                        + req.getServletPath()      //请求页面或其他地址
                        + "?" + (req.getQueryString()); //参数

                log.setUrl(url);
                log.setRefererUrl(req.getHeader("referer"));
                String ua=req.getHeader("user-agent");
                //ua不允许太长
                if(ua!=null && ua.length()>500){
                    ua=ua.substring(0,499);
                }
                log.setUa(ua);
                log.setIp(getIpAddr(req));

                if (log.isValid()) {
                    DPM_LOG.info(log.toJson());
                }

            }
        }catch (Exception e){
            LOG.error("DpmFilter process error,message= "+ e.getMessage());
        }

        filterChain.doFilter(servletRequest,servletResponse);
    }

    public static void main(String[] args) throws Exception{
        String s="eyJhaWQiOjEsImNpZCI6MTUzOTM2MX0=";
        String json = new String(new BASE64Decoder().decodeBuffer(s),"utf-8");
        System.out.println(json);
    }

    @Override
    public void destroy() {

    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if(ip!=null && ip.trim().length()>0){
            String[] ips=ip.trim().split(",");
            int size=ips.length;
            if(size>0){
                ip=ips[size-1].trim();
            }
        }
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)){
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if(ip!=null && ip.startsWith("0:0:0:0")){
            ip="127.0.0.1";
        }
        return ip;
    }

    /** DPM 点击 */
    private static final int DpmTypeClick=2;
    /** DPM 曝光*/
    private static final int DpmTypExposure=1;

    private static class DpmLog{
        private Long appId;
        private Long consumerId;
        private Integer dpmType;
        private String dpm;
        private String refererDpm;
        private String url;
        private String refererUrl;
        private String ua;
        private Date time=new Date();
        private String ip;

        public String toJson(){
            JSONObject json=new JSONObject();
            json.put("appId",appId);
            json.put("consumerId",consumerId);
            json.put("dpmType",dpmType);
            json.put("dpm",dpm);
            json.put("time",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time));
            if(refererDpm!=null){
                json.put("refererDpm",refererDpm);
            }
            if(url!=null){
                json.put("url",url);
            }
            if(refererUrl!=null){
                json.put("refererUrl",refererUrl);

            }
            if(ua!=null){
                json.put("ua",ua);
            }

            if(ip!=null){
                json.put("ip",ip);
            }

            return json.toJSONString();
        }

        public boolean isValid(){
            if(appId==null || appId<=0){
                return false;
            }
            if(consumerId==null || consumerId<=0){
                return false;
            }
            if(dpm==null){
                return false;
            }
            if(dpmType==null){
                return false;
            }
            return true;
        }



        public String getDpm() {
            return dpm;
        }

        public void setDpm(String dpm) {
            this.dpm = dpm;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }


        public String getUa() {
            return ua;
        }

        public void setUa(String ua) {
            this.ua = ua;
        }

        public Date getTime() {
            return time;
        }


        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Long getAppId(){
            return appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public Long getConsumerId(){
            return consumerId;
        }

        public void setConsumerId(Long consumerId) {
            this.consumerId = consumerId;
        }

        public Integer getDpmType() {
            return dpmType;
        }

        public void setDpmType(Integer dpmType) {
            this.dpmType = dpmType;
        }

        public String getRefererDpm() {
            return refererDpm;
        }

        public void setRefererDpm(String refererDpm) {
            this.refererDpm = refererDpm;
        }

        public String getRefererUrl() {
            return refererUrl;
        }

        public void setRefererUrl(String refererUrl) {
            this.refererUrl = refererUrl;
        }
    }
}
