///*
// * Copyright 2012-2015 the original author or authors.
// *
// * Licensed under the Apache License, Version 2.0 (the "License");
// * you may not use this file except in compliance with the License.
// * You may obtain a copy of the License at
// *
// *      http://www.apache.org/licenses/LICENSE-2.0
// *
// * Unless required by applicable law or agreed to in writing, software
// * distributed under the License is distributed on an "AS IS" BASIS,
// * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// * See the License for the specific language governing permissions and
// * limitations under the License.
// */
//
//package cn.com.duiba.boot.ext.autoconfigure;
//
//import org.springframework.beans.BeansException;
//import org.springframework.beans.factory.BeanFactory;
//import org.springframework.beans.factory.BeanFactoryAware;
//import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
//import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
//import org.springframework.boot.autoconfigure.AutoConfigureBefore;
//import org.springframework.boot.autoconfigure.AutoConfigureOrder;
//import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
//import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
//import org.springframework.boot.autoconfigure.condition.SearchStrategy;
//import org.springframework.boot.context.config.ConfigFileApplicationListener;
//import org.springframework.boot.context.event.ApplicationPreparedEvent;
//import org.springframework.context.*;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.context.annotation.ConfigurationClassPostProcessor;
//import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
//import org.springframework.core.Ordered;
//import org.springframework.core.env.*;
//import org.springframework.core.io.Resource;
//import org.springframework.core.io.support.ResourcePropertySource;
//import org.springframework.util.StringUtils;
//
//import java.io.IOException;
//import java.util.Iterator;
//import java.util.Properties;
//
///**
// *
// * 兑吧配置文件自动解密
// * @author huangwenqi
// */
//@Configuration
//@AutoConfigureOrder(Ordered.HIGHEST_PRECEDENCE)
//public class EncryptedPropertyAutoConfiguration implements ApplicationListener<ApplicationPreparedEvent> {
//
//	@Override
//	public void onApplicationEvent(ApplicationPreparedEvent event) {
//		PropertySourceDecodeOrderingPostProcessor processor = new PropertySourceDecodeOrderingPostProcessor(event.getApplicationContext());
//		event.getApplicationContext().addBeanFactoryPostProcessor(processor);
//	}
//
//	/**
//	 * {@link BeanFactoryPostProcessor} to re-order our property sources below any
//	 * {@code @PropertySource} items added by the {@link ConfigurationClassPostProcessor}.
//	 */
//	private class PropertySourceDecodeOrderingPostProcessor
//			implements BeanFactoryPostProcessor, Ordered {
//
//		private ConfigurableApplicationContext context;
//
//		PropertySourceDecodeOrderingPostProcessor(ConfigurableApplicationContext context) {
//			this.context = context;
//		}
//
//		@Override
//		public int getOrder() {
//			return Ordered.HIGHEST_PRECEDENCE;
//		}
//
//		@Override
//		public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory)
//				throws BeansException {
//			decodeProperties(this.context.getEnvironment());
//
//			String resolvedLocation = this.context.getEnvironment().getProperty("duiba.config.location");
//			Resource resource = this.context.getResource(resolvedLocation);
//			try {
//				ResourcePropertySource rps = null;
//				rps = new ResourcePropertySource(resource);
//				addPropertySource(rps);
//			} catch (IOException e) {
//				throw new RuntimeException(e);
//			}
//		}
//
//		private void addPropertySource(ResourcePropertySource propertySource) {
//			String name = propertySource.getName();
//			MutablePropertySources propertySources = ((ConfigurableEnvironment) this.context.getEnvironment()).getPropertySources();
//			if (propertySources.contains(name)) {
//				// We've already added a version, we need to extend it
//				PropertySource<?> existing = propertySources.get(name);
//				if (existing instanceof CompositePropertySource) {
//					((CompositePropertySource) existing).addFirstPropertySource(propertySource.withResourceName());
//				}
//				else {
//					if (existing instanceof ResourcePropertySource) {
//						existing = ((ResourcePropertySource) existing).withResourceName();
//					}
//					CompositePropertySource composite = new CompositePropertySource(name);
//					composite.addPropertySource(propertySource.withResourceName());
//					composite.addPropertySource(existing);
//					propertySources.replace(name, composite);
//				}
//			}
//			else {
//				if (this.propertySourceNames.isEmpty()) {
//					propertySources.addLast(propertySource);
//				}
//				else {
//					String firstProcessed = this.propertySourceNames.get(this.propertySourceNames.size() - 1);
//					propertySources.addBefore(firstProcessed, propertySource);
//				}
//			}
//			this.propertySourceNames.add(name);
//		}
//
//		private void decodeProperties(ConfigurableEnvironment environment) {
//			MutablePropertySources propertySources = environment.getPropertySources();
//			for(Iterator<PropertySource<?>> iterator = propertySources.iterator(); iterator.hasNext();){
//				PropertySource<?> propertySource = iterator.next();
//				if(propertySource instanceof ResourcePropertySource){
//					Properties decodedProperties = new Properties();
//					ResourcePropertySource resourcePropertySource = (ResourcePropertySource)propertySource;
//					for(String propertyName : resourcePropertySource.getPropertyNames()){
//						String propertyValue = (String)resourcePropertySource.getProperty(propertyName);
//						decodedProperties.put(propertyName, propertyValue);
//					}
//
//					ResourcePropertySource decodedResourcePropertySource = new ResourcePropertySource(resourcePropertySource.getName(),"", decodedProperties);
//				}
//			}
//			ConfigFileApplicationListener.ConfigurationPropertySources
//					.finishAndRelocate(environment.getPropertySources());
//			PropertySource<?> defaultProperties = environment.getPropertySources()
//					.remove(DEFAULT_PROPERTIES);
//			if (defaultProperties != null) {
//				environment.getPropertySources().addLast(defaultProperties);
//			}
//		}
//
//	}
//}
