package cn.com.duiba.boot.ext.autoconfigure.accesslog;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xuhengfei on 16/12/27.
 */
public class AccessLogFilter implements Filter{

    public static ThreadLocal<Long> AppId=new ThreadLocal<>();
    public static ThreadLocal<Long> ConsumerId=new ThreadLocal<>();


    private static Logger AccessLog= LoggerFactory.getLogger("duiba_access_log");

    private static Logger log=LoggerFactory.getLogger(AccessLogFilter.class);

    private static final String DUIBA_PERF="_duibaPerf";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {

        try {
            HttpServletRequest req = (HttpServletRequest) servletRequest;
            //判断是否性能压测url
            boolean isPerfUrl=false;

            String _duibaPerf=req.getParameter(DUIBA_PERF);
            if(_duibaPerf!=null && "1".equals(_duibaPerf)){
                isPerfUrl=true;
            }

            if(!isPerfUrl){
                Cookie[] cookies = req.getCookies();
                if(cookies!=null){
                    for(Cookie c:cookies){
                        if(DUIBA_PERF.equals(c.getName()) && "1".equals(c.getValue())){
                            isPerfUrl=true;
                            break;
                        }
                    }
                }

            }

            if(!isPerfUrl){
                processAccessLog(req);
            }


        }catch (Exception e){
            log.error("AccessLogFilter process error, message="+e.getMessage());
        }

        try {

            filterChain.doFilter(servletRequest, servletResponse);

        }finally {
            AppId.remove();
            ConsumerId.remove();
        }
    }


    private void processAccessLog(HttpServletRequest req) throws Exception{

        Map<String, Object> map = new HashMap<>();
        map.put("url_host", req.getHeader("host"));
        map.put("url_path", req.getRequestURI());
        map.put("url_query", req.getQueryString());

        map.put("http_method",req.getMethod());

        //如果url中有callback参数,认为此url是一个JSONP请求,标记为POST类型,不作为PV统计
        String callback=req.getParameter("callback");
        if(callback!=null && !"".equals(callback.trim())){
            map.put("http_method","POST");
        }


        Cookie[] cookies = req.getCookies();
        Map<String, Cookie> cookieMap = new HashMap<>();
        if(cookies!=null){
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c);
            }
        }


        Cookie _ac = cookieMap.get("_ac");
        if (_ac != null){//优先从cookie取数据
            try {
                String json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()), "utf-8");
                if(json!=null){
                    JSONObject object = JSONObject.parseObject(json);
                    map.put("app_id",object.getLong("aid"));
                    map.put("consumer_id",object.getLong("cid"));
                }
            }catch(Exception e){
                log.warn("_ac decode fail , _ac= "+_ac.getValue());
            }

        }
        //如果cookie中没有数据,则尝试从线程变量中取数据
        if(!map.containsKey("consumer_id")){
            Long consumerId=ConsumerId.get();
            if(consumerId!=null){
                map.put("consumer_id",consumerId);
            }
        }

        if(!map.containsKey("app_id")){
            Long appId=AppId.get();
            if(appId!=null){
                map.put("app_id",appId);
            }
        }

        Map<String,String> collCookie=new HashMap<String,String>();

        for(String key:cookieMap.keySet()){
            if(key.startsWith("_coll_")){
                collCookie.put(key,cookieMap.get(key).getValue());
            }
        }
        //特殊处理
        String slotId=req.getParameter("adslotId");
        if(slotId!=null){
            collCookie.put("_coll_slot",slotId);
        }
        String deviceId=req.getParameter("deviceId");
        if(deviceId!=null){
            collCookie.put("_coll_device",deviceId);
        }

        if(!collCookie.isEmpty()){
            map.put("cookie",collCookie);
        }


        String ua = req.getHeader("user-agent");
        if (ua != null && ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (ua != null) {
            map.put("user_agent", ua);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = req.getHeader("referer");
        if (referer != null) {
            map.put("referer", referer);
        }
        String ip = getIpAddr(req);
        if (ip != null) {
            map.put("ip", ip);
        }


        AccessLog.info(JSON.toJSONString(map));
    }

    @Override
    public void destroy() {

    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if(ip!=null && ip.trim().length()>0){
            String[] ips=ip.trim().split(",");
            int size=ips.length;
            if(size>0){
                ip=ips[size-1].trim();
            }
        }
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)){
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if(ip!=null && ip.startsWith("0:0:0:0")){
            ip="127.0.0.1";
        }
        return ip;
    }

}
