package cn.com.duiba.boot.ext.autoconfigure.threadpool;

import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import cn.com.duiba.wolf.concurrent.AbortPolicyWithReport;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;

import javax.annotation.Resource;
import java.util.concurrent.*;

/**
 * 自动构建线程池，使用文档：http://cf.dui88.com/pages/viewpage.action?pageId=4505751
 * Created by wenqi.huang on 2017/2/7.
 */
@Configuration
@ConditionalOnClass(ThreadPoolExecutorFactoryBean.class)
@EnableConfigurationProperties(ThreadPoolProperties.class)
public class ThreadPoolAutoConfiguration {

    @Resource
    private ThreadPoolProperties threadPoolProperties;

    /**
     * 构建普通线程池
     * @return
     */
    @Bean(name = "executorService", destroyMethod = "shutdown")
    @ConditionalOnProperty(name="duiba.threadpool.enabled", havingValue="true", matchIfMissing = false)
    public ExecutorService executorService(){
        BlockingQueue<Runnable> queue;
        int queueSize = threadPoolProperties.getQueueSize();
        if(queueSize == 0){
            queue = new SynchronousQueue<>();
        }else{
            queue = new ArrayBlockingQueue<Runnable>(queueSize);
        }

        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threadPoolProperties.getCoreSize(),
                threadPoolProperties.getMaxSize(),
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("DuibaBiz"),
                new AbortPolicyWithReport());

        return new ThreadPoolExecutorWrapper(threadPool, threadPoolProperties.getShutdownTimeout());
    }

    /**
     * 配置定时调度线程池
     * @return
     */
    @Bean(name = "scheduledExecutorService", destroyMethod = "shutdown")
    @ConditionalOnProperty(name="duiba.threadpool.scheduled.enabled", havingValue="true", matchIfMissing = false)
    public ScheduledExecutorService scheduledExecutorService(){
        ScheduledThreadPoolExecutor scheduledThreadPool = new ScheduledThreadPoolExecutor(threadPoolProperties.getScheduled().getCoreSize(),
                new NamedThreadFactory("DuibaBizScheduled"),
                new AbortPolicyWithReport());

        return new ScheduledThreadPoolExecutorWrapper(scheduledThreadPool, threadPoolProperties.getScheduled().getShutdownTimeout());
    }

}
