/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.ext.autoconfigure.perftest.PerfTestAutoConfiguration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.Assert;

public class PerfTestRoutingDataSource
extends AbstractRoutingDataSource
implements DisposableBean {
    private static final String ORIGINAL_DATASOURCE = "original";
    private static final String TEST_DATASOURCE = "test";
    private static final String TEST_SCHEME_PREFIX = "perf__";
    private volatile boolean hasTestDataSource = false;
    private volatile boolean testDataSourceInitted = false;
    private String originalScheme;
    private BasicDataSource originalDataSource;
    private BasicDataSource shadeDataSource;
    private ConcurrentMap<Object, Object> targetDataSources = new ConcurrentHashMap<Object, Object>();
    private boolean thisInitted = false;

    public PerfTestRoutingDataSource(DataSource originalDataSource) {
        if (!(originalDataSource instanceof BasicDataSource)) {
            throw new IllegalStateException("\u68c0\u6d4b\u5230\u6709DataSource\u6ca1\u6709\u4f7f\u7528dbcp2\uff0c\u8bf7\u5148\u6539\u6210dbcp2\u3002");
        }
        this.originalDataSource = (BasicDataSource)originalDataSource;
    }

    public void afterPropertiesSet() {
        if (this.thisInitted) {
            return;
        }
        this.thisInitted = true;
        this.targetDataSources.put(ORIGINAL_DATASOURCE, this.originalDataSource);
        String originalUrl = this.originalDataSource.getUrl();
        this.originalScheme = this.getOriginalScheme(originalUrl);
        super.setTargetDataSources(this.targetDataSources);
        super.afterPropertiesSet();
    }

    private BasicDataSource getTestDataSource(BasicDataSource originalDataSource) {
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        HashSet<String> schemes = new HashSet<String>();
        try {
            connection = originalDataSource.getConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery("show databases");
            while (rs.next()) {
                schemes.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        String testScheme = TEST_SCHEME_PREFIX + this.originalScheme;
        if (!schemes.contains(testScheme)) {
            return null;
        }
        String testUrl = this.getTestUrl(originalDataSource.getUrl());
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(originalDataSource.getDriverClassName());
        ds.setUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());
        ds.setDefaultQueryTimeout(originalDataSource.getDefaultQueryTimeout());
        ds.setInitialSize(originalDataSource.getInitialSize());
        ds.setLogAbandoned(originalDataSource.getLogAbandoned());
        ds.setMaxIdle(originalDataSource.getMaxIdle());
        ds.setMaxTotal(originalDataSource.getMaxTotal());
        ds.setMinIdle(originalDataSource.getMinIdle());
        ds.setSoftMinEvictableIdleTimeMillis(originalDataSource.getSoftMinEvictableIdleTimeMillis());
        ds.setValidationQuery(originalDataSource.getValidationQuery());
        ds.setValidationQueryTimeout(originalDataSource.getValidationQueryTimeout());
        ds.setTimeBetweenEvictionRunsMillis(originalDataSource.getTimeBetweenEvictionRunsMillis());
        ds.setTestWhileIdle(originalDataSource.getTestWhileIdle());
        ds.setTestOnBorrow(originalDataSource.getTestOnBorrow());
        ds.setTestOnReturn(originalDataSource.getTestOnReturn());
        ds.setTestOnCreate(originalDataSource.getTestOnCreate());
        ds.setMaxWaitMillis(originalDataSource.getMaxWaitMillis());
        ds.setNumTestsPerEvictionRun(originalDataSource.getNumTestsPerEvictionRun());
        ds.setRemoveAbandonedOnBorrow(originalDataSource.getRemoveAbandonedOnBorrow());
        ds.setRemoveAbandonedOnMaintenance(originalDataSource.getRemoveAbandonedOnMaintenance());
        ds.setRemoveAbandonedTimeout(originalDataSource.getRemoveAbandonedTimeout());
        return ds;
    }

    private String getTestUrl(String originalUrl) {
        int index = originalUrl.lastIndexOf("/");
        if (index > 0) {
            return originalUrl.substring(0, index + 1) + TEST_SCHEME_PREFIX + originalUrl.substring(index + 1, originalUrl.length());
        }
        throw new IllegalArgumentException(originalUrl + " is invalid");
    }

    private String getOriginalScheme(String originalUrl) {
        int index = originalUrl.lastIndexOf("/");
        if (index > 0) {
            String schemeAfter = originalUrl.substring(index + 1, originalUrl.length());
            int index1 = schemeAfter.indexOf("?");
            if (index1 > 0) {
                return schemeAfter.substring(0, index1);
            }
            return schemeAfter;
        }
        throw new IllegalArgumentException(originalUrl + " is invalid");
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.targetDataSources, (String)"DataSource router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        DataSource dataSource = (DataSource)this.targetDataSources.get(lookupKey);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected Object determineCurrentLookupKey() {
        Boolean isTestMode = (Boolean)PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        if (isTestMode != null && isTestMode.booleanValue()) {
            if (!this.testDataSourceInitted) {
                this.initTestDataSource();
            }
            if (!this.hasTestDataSource) {
                throw new IllegalStateException(this.originalScheme + "\u7684\u5f71\u5b50\u5e93\u4e0d\u5b58\u5728\uff0c\u653e\u5f03\u672c\u6b21\u8bf7\u6c42");
            }
            return TEST_DATASOURCE;
        }
        return ORIGINAL_DATASOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTestDataSource() {
        PerfTestRoutingDataSource perfTestRoutingDataSource = this;
        synchronized (perfTestRoutingDataSource) {
            if (!this.testDataSourceInitted) {
                BasicDataSource testDataSource = this.getTestDataSource(this.originalDataSource);
                if (testDataSource != null) {
                    this.hasTestDataSource = true;
                    this.shadeDataSource = testDataSource;
                    this.targetDataSources.putIfAbsent(TEST_DATASOURCE, testDataSource);
                } else {
                    this.logger.warn((Object)(this.originalScheme + " \u6ca1\u6709\u5bf9\u5e94\u7684\u5f71\u5b50\u6570\u636e\u5e93\uff08\u5728\u540c\u4e2a\u5e93\u4e2d\u4ee5perf__\u5f00\u5934\u7684scheme\uff09\uff0c\u5982\u679c\u4f60\u914d\u7f6e\u4e86\uff0c\u9700\u8981\u91cd\u542f\u672c\u5e94\u7528\u751f\u6548"));
                }
                this.testDataSourceInitted = true;
            }
        }
    }

    public void destroy() throws Exception {
        if (this.targetDataSources != null) {
            for (Object object : this.targetDataSources.values()) {
                try {
                    if (object instanceof BasicDataSource) {
                        ((BasicDataSource)object).close();
                        continue;
                    }
                    if (!(object instanceof AutoCloseable)) continue;
                    ((AutoCloseable)object).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public BasicDataSource getOriginalDataSource() {
        return this.originalDataSource;
    }

    public BasicDataSource getShadeDataSource() {
        return this.shadeDataSource;
    }
}

