package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 此Filter用于对超时请求打印warn日志
 * Created by huangwenqi on 16/12/27.
 */
public class DBTimeProfileFilter implements Filter{

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        try {
            DBTimeProfile.start();
            filterChain.doFilter(servletRequest, servletResponse);
        }finally {
            DBTimeProfile.end(request.getRequestURI());
        }
    }

    @Override
    public void destroy() {

    }

}
