package cn.com.duiba.boot.ext.autoconfigure.web;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by wenqi.huang on 2017/4/11.
 */
@RestController
public class MonitorController {

    private volatile boolean inService = true;

    @RequestMapping("/monitor/check")
    public String check(HttpServletResponse response){
        if(!inService){
            response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
        return inService ? "OK" : "INVALID";
    }

    @RequestMapping("/monitor/stop")
    public String stop(){
        inService = false;
        return "OK";
    }

    @RequestMapping("/monitor/start")
    public String start(){
        inService = true;
        return "OK";
    }
}
