package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by wenqi.huang on 2017/4/11.
 */
@RestController
public class BootMonitorController {

    private volatile boolean inService = true;

    @RequestMapping("/monitor/check")
    public String check(HttpServletResponse response){
        if(!inService){
            response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
        return inService ? "OK" : "INVALID";
    }

    @RequestMapping("/monitor/stop")
    public String stop(HttpServletRequest request){
        if(!isLocalRequest(request)){
            return "NO PERMISSION";
        }
        inService = false;
        return "OK";
    }

    @RequestMapping("/monitor/start")
    public String start(HttpServletRequest request){
        System.out.println(request.getRequestURL().toString());
        if(!isLocalRequest(request)){
            return "NO PERMISSION";
        }
        inService = true;
        return "OK";
    }

    private boolean isLocalRequest(HttpServletRequest request){
        return RequestTool.isLocalRequest(request);
    }
}
