/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.redis;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class Hessian2SerializationRedisSerializer
implements RedisSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(Hessian2SerializationRedisSerializer.class);
    public static final int FLAG_COMPRESSED = 1;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public static int MAX_SIZE = 0x100000;
    private int compressionThreshold = 1024;
    private int maxSize = MAX_SIZE;
    private String compressMode = "gzip";
    private static int COMPRESS_RATIO = 8;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes.length == 1) {
            throw new SerializationException("Cannot deserialize, bytes.length must be > 1, maybe this key is used by other redis client\uff0cor you use RedisTemplate to incr/decr");
        }
        try {
            byte flags = bytes[0];
            byte[] data = Arrays.copyOfRange(bytes, 1, bytes.length);
            if ((flags & 1) != 0) {
                data = this.decompress(data);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)in);
            return hessian2Input.readObject();
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize, maybe this key is used by other redis client", (Throwable)ex);
        }
    }

    public byte[] serialize(Object object) {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output((OutputStream)out);
            hessian2Output.writeObject(object);
            hessian2Output.flush();
            byte[] data = out.toByteArray();
            int flags = 0;
            if (data.length > this.compressionThreshold) {
                byte[] compressed = this.compress(data);
                if (compressed.length < data.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Compressed " + object.getClass().getName() + " from " + data.length + " to " + compressed.length);
                    }
                    data = compressed;
                    flags = (byte)(flags | 1);
                } else if (log.isDebugEnabled()) {
                    log.debug("Compression increased the size of " + object.getClass().getName() + " from " + data.length + " to " + compressed.length);
                }
            }
            if (data.length > this.maxSize) {
                throw new IllegalArgumentException("Cannot cache data larger than " + this.maxSize + " byte (you tried to cache a " + data.length + " byte object)");
            }
            out = new ByteArrayOutputStream();
            out.write(flags);
            out.write(data);
            return out.toByteArray();
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize", (Throwable)ex);
        }
    }

    public final byte[] compress(byte[] in) {
        if ("zip".equals(this.compressMode)) {
            return this.zipCompress(in);
        }
        return Hessian2SerializationRedisSerializer.gzipCompress(in);
    }

    private byte[] zipCompress(byte[] in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(in.length);
        DeflaterOutputStream os = new DeflaterOutputStream(baos);
        try {
            os.write(in);
            os.finish();
            try {
                os.close();
            }
            catch (IOException e) {
                log.error("Close DeflaterOutputStream error", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                log.error("Close ByteArrayOutputStream error", (Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    private static byte[] gzipCompress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            if (gz != null) {
                try {
                    gz.close();
                }
                catch (IOException e) {
                    log.error("Close GZIPOutputStream error", (Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error("Close ByteArrayOutputStream error", (Throwable)e);
                }
            }
        }
        byte[] rv = bos.toByteArray();
        return rv;
    }

    protected byte[] decompress(byte[] in) {
        if ("zip".equals(this.compressMode)) {
            return this.zipDecompress(in);
        }
        return this.gzipDecompress(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zipDecompress(byte[] in) {
        int size = in.length * COMPRESS_RATIO;
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        InflaterInputStream is = new InflaterInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        try {
            int len;
            byte[] uncompressMessage = new byte[size];
            while ((len = is.read(uncompressMessage)) > 0) {
                baos.write(uncompressMessage, 0, len);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error("Failed to decompress data", (Throwable)e);
            baos = null;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error("failed to close InflaterInputStream");
            }
            try {
                bais.close();
            }
            catch (IOException e) {
                log.error("failed to close ByteArrayInputStream");
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                log.error("failed to close ByteArrayOutputStream");
            }
        }
        return baos == null ? null : baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gzipDecompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            GZIPInputStream gis = null;
            try {
                gis = new GZIPInputStream(bis);
                byte[] buf = new byte[16384];
                int r = -1;
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                log.error("Failed to decompress data", (Throwable)e);
                bos = null;
            }
            finally {
                if (gis != null) {
                    try {
                        gis.close();
                    }
                    catch (IOException e) {
                        log.error("Close GZIPInputStream error", (Throwable)e);
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        log.error("Close ByteArrayInputStream error", (Throwable)e);
                    }
                }
            }
        }
        return bos == null ? null : bos.toByteArray();
    }

    public static void main(String[] args) {
        Hessian2SerializationRedisSerializer s = new Hessian2SerializationRedisSerializer();
        byte[] bs = s.serialize("\u963f\u53d1\u662f\u975e\u5f97\u5931fsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfdfsfsfsfsdfsdfd");
        String str = (String)s.deserialize(bs);
        System.out.println(str);
    }
}

