package cn.com.duiba.boot.ext.autoconfigure.cat;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;

import cn.com.duiba.catmonitor.CatInstance;

/**
 * 加入AOP，监控spring-data-mongodb执行耗时
 */
@Aspect
public class CatSpringDataMongodbPlugin {

	private static final String space = "Mongodb";

	/**
	 * 拦截MongoOperations类所有接口，记录执行耗时
	 * 
	 * @param joinPoint
	 * @return
	 * @throws Throwable
	 */
	@Around("execution(* org.springframework.data.mongodb.core.MongoOperations.*(..))")
	public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();
		if (CatInstance.isEnable()) {
			Transaction transaction = Cat.newTransaction(space, methodName);
			try {
				Object obj = joinPoint.proceed();
				transaction.setStatus(Message.SUCCESS);
				return obj;
			} catch (Throwable e) {
				//Cat.logError(e);
				transaction.setStatus(e);
				throw e;
			} finally {
				transaction.complete();
			}
		}
		return joinPoint.proceed();
	}

}
