package cn.com.duiba.boot.ext.autoconfigure.data.elasticsearch;

import org.elasticsearch.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月02日 10:22
 * @descript:
 * @version: 1.0
 */
@Configuration
@ConditionalOnClass({ Client.class, ElasticsearchTemplate.class })
@AutoConfigureAfter(ElasticsearchAutoConfiguration.class)
@AutoConfigureBefore(org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchDataAutoConfiguration.class)
@EnableConfigurationProperties(ElasticsearchProperties.class)
public class ElasticsearchDataAutoConfiguration {

    @Autowired
    private ElasticsearchProperties elasticsearchProperties;

    @Bean
    @ConditionalOnMissingBean
    public ElasticsearchTemplate elasticsearchTemplate(Client client,ElasticsearchConverter converter) {
        try {
            return new ElasticsearchTemplate(client, converter,elasticsearchProperties.getSearchTimeout());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}
