package cn.com.duiba.boot.ext.autoconfigure.initserver;

import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

import java.util.List;

/**
 * Created by wenqi.huang on 2017/6/16.
 */
public class BeanPostProcessorOfSpecified implements BeanPostProcessor, Ordered {

    private List<SpecifiedBeanPostProcessor> processorList;

    public BeanPostProcessorOfSpecified(List<SpecifiedBeanPostProcessor> processorList) {
        this.processorList = processorList;
    }

    @Override
    public int getOrder() {
        return -2;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for(SpecifiedBeanPostProcessor p : processorList){
            if(p.getBeanType().isAssignableFrom(bean.getClass())){
                bean = p.postProcessBeforeInitialization(bean, beanName);
            }
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for(SpecifiedBeanPostProcessor p : processorList){
            if(p.getBeanType().isAssignableFrom(bean.getClass())){
                bean = p.postProcessAfterInitialization(bean, beanName);
            }
        }
        return bean;
    }

}
