package cn.com.duiba.boot.ext.autoconfigure.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import sun.security.util.SecurityConstants;

import javax.security.auth.AuthPermission;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.LoggingPermission;

/**
 * 自动配置SecurityManager，防止shell攻击（即使有fastjson等存在shell漏洞的框架也能有效防止）
 * http://www.cnblogs.com/yiwangzhibujian/p/6207212.html
 * Created by wenqi.huang on 2017/4/5.
 */
@Configuration
public class SecurityManagerAutoConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(SecurityManagerAutoConfiguration.class);

    static Set<String> forbiddenPermNames = new HashSet<>(10);

    static{
        //forbiddenPermNames.add("stopThread");
        forbiddenPermNames.add("queuePrintJob");
        //访问https url时jdk会创建 JCESecurityManager
        //forbiddenPermNames.add("createSecurityManager");

        //测试模式不屏蔽下面这些权限。否则运行单测会报错
        if(conditionalOnMissingClass("org.junit.Test","org.testng.annotations.Test")) {//,"org.gradle.api.internal.tasks.testing.worker.TestWorker"
            forbiddenPermNames.add("setIO");
            forbiddenPermNames.add("setSecurityManager");
        }else{
            logger.warn("侦测到在测试模式, SecurityManager允许权限:[setIO/setSecurityManager],如果使用java -jar运行时（非测试模式）看到这条日志，请确保把junit/testng/spring-test等测试框架设置为testCompile依赖模式（即打的jar包中不要包含junit/testng的jar包）");
        }
    }

    //指定的类都不存在时返回true，有一个存在则返回false
    private static boolean conditionalOnMissingClass(String... classNames) {
        boolean existsOne = false;
        for(String className : classNames) {
            try {
                Class.forName(className);
                existsOne = true;
                break;
            } catch (ClassNotFoundException e) {
                //Ignore
            }
        }

        return !existsOne;
    }

    @Bean
    public ApplicationListener _duibaSecurityManagerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            private boolean flag = true;

            @Override
            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if(flag){
                    if(System.getSecurityManager() == null) {
                        System.setSecurityManager(new SecurityManager() {
                            @Override
                            public void checkExec(String cmd) {
                                //不允许执行shell脚本
                                super.checkExec(cmd);
                            }

                            @Override
                            public void checkCreateClassLoader() {
                                //允许创建ClassLoader
                                //super.checkCreateClassLoader();
                            }

                            @Override
                            public void checkRead(String file) {
                                //啥都不做，允许读文件
                            }
                            @Override
                            public void checkRead(String file, Object context) {
                                //super.checkRead(file, context);
                            }
                            @Override
                            public void checkWrite(String file) {
                                //啥都不做，允许写文件
                            }
                            @Override
                            public void checkDelete(String file) {
                                //啥都不做，允许删文件
                            }

                            @Override
                            public void checkPackageAccess(String pkg) {
                                //是否允许访问指定包下的类（包括正常访问、反射）
                                //super.checkPackageAccess(pkg);
                            }

                            @Override
                            public void checkAccess(Thread t) {
                                //super.checkAccess(t);
                            }

                            @Override
                            public void checkAccess(ThreadGroup g) {
                                //super.checkAccess(g);
                            }

                            @Override
                            public void checkMemberAccess(Class<?> clazz, int which) {
                                //super.checkMemberAccess(clazz, which);
                                //这个写法只有jdk7可以生效，就是说jdk8中仍然能通过反射来执行shell脚本，绕过SecurityManager，目前暂时没有好办法，除非设置javaagent
                                String className = clazz.getName();
                                if(className.equals("java.lang.ProcessImpl") || className.equals("java.lang.UNIXProcess")
                                        || className.equals("java.lang.ProcessBuilder")){
                                    throw new AccessControlException("not allowed to reflect access class:" + className);
                                }
                            }

                            @Override
                            public void checkPermission(Permission perm) {
//                                Class<?>[] classes = this.getClassContext();
//                                StackTraceElement[] st = new RuntimeException().getStackTrace();
                                //这里判断Permission类型的方法，如果换成Set.contains判断，速度会降低2000倍，所以用if来判断
                                if(perm instanceof AllPermission
                                        || perm instanceof PropertyPermission
                                        || perm instanceof SerializablePermission
                                        || perm instanceof ReflectPermission
                                        || perm instanceof NetPermission
                                        || perm instanceof SQLPermission
                                        || perm instanceof SecurityPermission
                                        || perm instanceof LoggingPermission
                                        || perm instanceof AuthPermission
                                        || perm instanceof SocketPermission){
                                    return;
                                }
                                if(perm instanceof FilePermission){
                                    FilePermission fp = (FilePermission)perm;
                                    if(fp.getActions().equals(SecurityConstants.FILE_EXECUTE_ACTION)){
                                        super.checkPermission(perm);
                                        return;
                                    }
                                }
                                if(forbiddenPermNames.contains(perm.getName())) {
                                    super.checkPermission(perm);
                                    return;
                                }
                            }

                            @Override
                            public void checkPermission(Permission perm, Object context) {
                                //super.checkPermission(perm, context);
                            }

                            @Override
                            public void checkExit(int status) {
                                //super.checkExit(status);
                            }

                            @Override
                            public void checkLink(String lib) {
                                //允许load so文件（jni）
                                //super.checkLink(lib);
                            }

                            @Override
                            public void checkRead(FileDescriptor fd) {
                                //允许从System.in读取数据
                                //super.checkRead(fd);
                            }

                            @Override
                            public void checkWrite(FileDescriptor fd) {
                                //允许往System.out/err写数据
                                //super.checkWrite(fd);
                            }

                            @Override
                            public void checkConnect(String host, int port) {
                                //super.checkConnect(host, port);
                            }

                            @Override
                            public void checkConnect(String host, int port, Object context) {
                                //super.checkConnect(host, port, context);
                            }

                            @Override
                            public void checkListen(int port) {
                                //super.checkListen(port);
                            }

                            @Override
                            public void checkAccept(String host, int port) {
                                //super.checkAccept(host, port);
                            }

                            @Override
                            public void checkMulticast(InetAddress maddr) {
                                //super.checkMulticast(maddr);
                            }

                            @Override
                            public void checkMulticast(InetAddress maddr, byte ttl) {
                                //super.checkMulticast(maddr, ttl);
                            }

                            @Override
                            public void checkPropertiesAccess() {
                                //super.checkPropertiesAccess();
                            }

                            @Override
                            public void checkPropertyAccess(String key) {
                                //super.checkPropertyAccess(key);
                            }

                            @Override
                            public void checkPackageDefinition(String pkg) {
                                //super.checkPackageDefinition(pkg);
                            }

                            @Override
                            public void checkSetFactory() {
                                //super.checkSetFactory();
                            }

                            @Override
                            public void checkSecurityAccess(String target) {
                                //super.checkSecurityAccess(target);
                            }

                        });

                    }

                    flag = false;
                }
            }
        };
    }
}
