package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.springframework.http.HttpStatus;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

/**
 *
 */
public class BootMonitorCheckFilter implements Filter{

    private volatile boolean inService = true;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        if(uri.equals("/monitor/check")){//检查服务器状态，OK表示正常，INVALID表示服务不可用
            if(!inService){
                response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(inService ? "OK" : "INVALID");
        }else if(uri.equals("/monitor/stop")){//让check接口返回INVALID
            if(!isLocalRequest(request)){
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = false;
            response.getWriter().write("OK");
        }else if(uri.equals("/monitor/start")){// 让check接口返回OK
            if(!isLocalRequest(request)){
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = true;
            response.getWriter().write("OK");
        }else{
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    /**
     * 访问的来源ip必须是127.0.0.1， 并且访问的url也必须是127.0.0.1
     * @param request
     * @return
     */
    private boolean isLocalRequest(HttpServletRequest request){
        boolean isFromLocalIp = RequestTool.isLocalRequest(request);
        if(!isFromLocalIp){
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if(url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        } catch (MalformedURLException e) {
            // Ignore
        }

        return isUrlFromLocal;
    }

    @Override
    public void destroy() {

    }

}
