/*
 * Copyright 2012-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.duiba.boot.ext.autoconfigure.web;

import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 自动配置Tomcat、Jetty等容器，增加http线程池监控，如果在队列中等待超过1秒，则打印error日志提示线程池过小
 */
@Configuration
@ConditionalOnWebApplication
public class DuibaEmbeddedServletContainerAutoConfiguration {

//	/**
//	 * Nested configuration for if Tomcat is being used.
//	 */
//	@Configuration
//	@ConditionalOnClass({ Servlet.class, Tomcat.class })
//	@ConditionalOnMissingBean(value = EmbeddedServletContainerFactory.class, search = SearchStrategy.CURRENT)
//	public static class EmbeddedTomcat {
//
//		@Bean
//		public TomcatEmbeddedServletContainerFactory tomcatEmbeddedServletContainerFactory() {
//			return new TomcatEmbeddedServletContainerFactory();
//		}
//
//	}

	@Bean
	public ThreadPoolServletContainerCustomizer getThreadPoolServletContainerCustomizer(){
		return new ThreadPoolServletContainerCustomizer();
	}

}
