/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web.mvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CustomRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        HandlerMethod m = super.getHandlerInternal(request);
        if (m == null) {
            return m;
        }
        MethodParameter[] parameters = m.getMethodParameters();
        if (parameters == null) {
            return m;
        }
        this.injectParameterAnnotations(parameters);
        return m;
    }

    private void injectParameterAnnotations(MethodParameter[] parameters) throws IllegalAccessException, InvocationTargetException {
        for (MethodParameter p : parameters) {
            Method method = p.getMethod();
            if (method == null) continue;
            Field field = ReflectionUtils.findField(p.getClass(), (String)"parameterAnnotations");
            field.setAccessible(true);
            if (field.get(p) != null) continue;
            Method requestMappingAnnotatedMethod = null;
            if (!this.isRequestMappingAnnotated(method)) {
                Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
                Class<?> superClass = method.getDeclaringClass().getSuperclass();
                ArrayList classesToSearch = new ArrayList();
                if (superClass != null || superClass != Object.class) {
                    classesToSearch.add(superClass);
                }
                classesToSearch.addAll(Arrays.asList(interfaces));
                for (Class clazz : classesToSearch) {
                    try {
                        Method superMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                        if (!this.isRequestMappingAnnotated(superMethod)) continue;
                        requestMappingAnnotatedMethod = superMethod;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            if (requestMappingAnnotatedMethod == null) continue;
            Annotation[] parameterAnnotations = null;
            Annotation[][] annotationArray = requestMappingAnnotatedMethod.getParameterAnnotations();
            if (p.getParameterIndex() >= 0 && p.getParameterIndex() < annotationArray.length) {
                Method adaptAnnotationArrayMethod = ReflectionUtils.findMethod(p.getClass(), (String)"adaptAnnotationArray", (Class[])new Class[]{Annotation[].class});
                adaptAnnotationArrayMethod.setAccessible(true);
                Annotation[] annotationArray2 = annotationArray[p.getParameterIndex()];
                Object[] args = new Object[]{annotationArray2};
                parameterAnnotations = (Annotation[])adaptAnnotationArrayMethod.invoke((Object)p, args);
            } else {
                parameterAnnotations = new Annotation[]{};
            }
            field.set(p, parameterAnnotations);
            p.getParameterAnnotations();
        }
    }

    private boolean isRequestMappingAnnotated(Method m) {
        Annotation[] arr;
        for (Annotation a : arr = m.getAnnotations()) {
            if (!(a instanceof RequestMapping) && a.getClass().getAnnotation(RequestMapping.class) == null) continue;
            return true;
        }
        return false;
    }
}

