/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dbexec;

import cn.com.duibaboot.ext.autoconfigure.dbexec.ExecutableCommand;
import cn.com.duibaboot.ext.autoconfigure.dbexec.JvmIdTool;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@ConfigurationProperties(prefix="endpoints.dbexec")
public class ExecMvcEndpoint
extends EndpointMvcAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecMvcEndpoint.class);
    private static final long SSE_TIMEOUT = 10000L;
    private final ExecEndpoint delegate;
    private static final ExecutorService es = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());

    public ExecMvcEndpoint(ExecEndpoint delegate) {
        super((Endpoint)delegate);
        this.delegate = delegate;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"}, value={"/{commandKey}"})
    public SseEmitter invoke(@PathVariable String commandKey) {
        if (!this.delegate.isEnabled()) {
            throw new UnsupportedOperationException("UnsupportedOperation");
        }
        if (StringUtils.isBlank((String)commandKey)) {
            throw new RuntimeException("commandKey \u4e0d\u80fd\u4e3a null");
        }
        if (!ExecutableCommand.contains(commandKey)) {
            throw new RuntimeException("\u975e\u6cd5\u7684 commandKey");
        }
        return this.buildSseEmitter(ExecutableCommand.get(commandKey));
    }

    private SseEmitter buildSseEmitter(ExecutableCommand executableCommand) {
        final SseEmitter sseEmitter = new SseEmitter(Long.valueOf(10000L));
        final String command = this.renderCommand(executableCommand);
        es.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Process process = null;
                InputStreamReader inputStreamReader = null;
                BufferedReader lineNumberReader = null;
                try {
                    String line;
                    process = Runtime.getRuntime().exec(command);
                    inputStreamReader = new InputStreamReader(process.getInputStream());
                    lineNumberReader = new LineNumberReader(inputStreamReader);
                    while ((line = ((LineNumberReader)lineNumberReader).readLine()) != null) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("execReuslt", (Object)line);
                        try {
                            sseEmitter.send((Object)jsonObject.toString(), MediaType.APPLICATION_JSON_UTF8);
                        }
                        catch (Exception e) {
                            LOGGER.info("sseEmitter.send \u5f80response\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0c\u53ef\u80fd\u5ba2\u6237\u7aef\u5df2\u7ecf\u5173\u95ed, {}", (Object)e.getMessage());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                    sseEmitter.completeWithError((Throwable)e);
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (lineNumberReader != null) {
                        try {
                            lineNumberReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    sseEmitter.complete();
                }
            }
        });
        return sseEmitter;
    }

    private String renderCommand(ExecutableCommand commandEnum) {
        String command = commandEnum.getCommand();
        command = command.replace("${vmid}", JvmIdTool.getVmId());
        return command;
    }

    @ConfigurationProperties(prefix="endpoints.dbexec")
    public static class ExecEndpoint
    extends AbstractEndpoint<SseEmitter> {
        public ExecEndpoint() {
            super("dbexec");
        }

        public SseEmitter invoke() {
            throw new UnsupportedOperationException("UnsupportedOperation");
        }
    }
}

