/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.memcached;

import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import cn.com.duibaboot.ext.autoconfigure.memcached.MemcachedProperties;
import net.rubyeye.xmemcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MemcachedProperties.class})
public class MemcachedClientAutoConfiguration {

    @ConditionalOnClass(value={MemcachedClient.class, XMemcacheClient.class})
    @ConditionalOnProperty(name={"duiba.memcached.servers"}, matchIfMissing=false)
    @ConditionalOnMissingBean(name={"cacheClient"})
    protected static class XMemcachedClientConfiguration
    extends MemcachedClientConfiguration {
        protected XMemcachedClientConfiguration() {
        }

        @Override
        @Bean(name={"cacheClient"})
        public CacheClient buildCacheClient() {
            XMemcacheClient cacheClient = new XMemcacheClient();
            cacheClient.setServers(this.memcachedProperties.getServers());
            cacheClient.setUsername(this.memcachedProperties.getUsername());
            cacheClient.setPassword(this.memcachedProperties.getPassword());
            cacheClient.setAuthInfos(this.memcachedProperties.getAuthInfos());
            cacheClient.setProtocol(this.memcachedProperties.getProtocol());
            cacheClient.setEnableHeartBeat(this.memcachedProperties.getEnableHeartBeat().booleanValue());
            cacheClient.setConnectionPoolSize(this.memcachedProperties.getConnectionPoolSize().intValue());
            cacheClient.setOperationTimeout(this.memcachedProperties.getOperationTimeout().intValue());
            return cacheClient;
        }
    }

    protected static abstract class MemcachedClientConfiguration {
        @Autowired
        protected MemcachedProperties memcachedProperties;

        protected MemcachedClientConfiguration() {
        }

        public abstract CacheClient buildCacheClient();
    }
}

