/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.alibaba.ttl.TtlCallable;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import java.util.concurrent.Callable;

public class CustomHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return new CallableWrapper((Callable)TtlCallable.get(callable));
    }

    private static class CallableWrapper
    implements Callable {
        private Callable callable;
        private RpcContext rpcContext = RpcContext.getContext().clone();

        public CallableWrapper(Callable callable) {
            this.callable = callable;
        }

        public Object call() throws Exception {
            RpcContext.setContext(this.rpcContext);
            try {
                Object v = this.callable.call();
                return v;
            }
            finally {
                RpcContext.removeContext();
            }
        }
    }
}

