package cn.com.duibaboot.ext.autoconfigure.javaagent.common;


import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.StaticMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassStaticMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.any;
import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * 拦截guava的CacheBuilder.build方法,进行两次build调用，从而生成两个Cache实例（一个给正常流量用，一个给压测流量用），并用一个新的Cache实例对它们进行包装。以防止压测流量影响正常流量
 */
public class GuavaCacheStaticBuildInstrumentation extends ClassStaticMethodsEnhancePluginDefine implements AgentPluginExtSpi {

    private static final String ENHANCE_CLASS = "com.google.common.cache.CacheBuilder";


    @Override
    protected StaticMethodsInterceptPoint[] getStaticMethodsInterceptPoints() {
        return new StaticMethodsInterceptPoint[]{
          new StaticMethodsInterceptPoint() {

              @Override
              public ElementMatcher<MethodDescription> getMethodsMatcher() {
                  return any();
              }

              @Override
              public String getMethodsInterceptor() {
                  return getInterceptorClassNames("guava-builder-interceptor");
              }

              @Override
              public boolean isOverrideArgs() {
                  return false;
              }
          }
        };
    }

    @Override
    protected ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }
}
