package cn.com.duibaboot.ext.autoconfigure.javaagent.common;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.HierarchyMatch.byHierarchyMatch;
import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * Created by guoyanfei .
 * 2019-04-15 .
 */
public class RedisLockInstrumentation extends ClassInstanceMethodsEnhancePluginDefine implements AgentPluginExtSpi {

    private static final String ENHANCE_CLASS = "cn.com.duiba.wolf.redis.RedisLock";

    @Override
    public ClassMatch enhanceClass() {
        return byHierarchyMatch(new String[]{ENHANCE_CLASS});
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
                new InstanceMethodsInterceptPoint() {
                    @Override
                    public ElementMatcher<MethodDescription> getMethodsMatcher() {
                        //此处的方法需要为所有MethodsInterceptor的超集，然后在每个MethodsInterceptor内部判断只处理自己需要的方法
                        return named("unlock");
                    }

                    @Override
                    public String getMethodsInterceptor() {
                        return getInterceptorClassNames("redis-lock-interceptor");
                    }

                    @Override public boolean isOverrideArgs() {
                        //如果任意一个MethodsInterceptor需要修改参数，则此处需要为true
                        return true;
                    }
                }
        };
    }
}
