package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * 计算sql真实的执行时间，排除等待空闲连接的时间
 */
@Aspect
public class CatDataSourcePlugin {
	
	@Around("execution(* javax.sql.DataSource.getConnection(..))")
	public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
		if(CatUtils.isCatEnabled()){
			Object result = joinPoint.proceed();

			//DataSource.getConnection执行完毕后开始计时。计算sql真实的执行时间，排除等待空闲连接的时间

			CatUtils.TransactionExt transactionExt = CatUtils.getCurrentTransaction();
			if(transactionExt != null) {
				Transaction sqlOnlyTransaction = Cat.newTransaction("SQL.only", transactionExt.getTransactionName());
				transactionExt.setTransaction(sqlOnlyTransaction);
			}

			return result;
		}else{
			return joinPoint.proceed();
		}
	}
	
}
