package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;

import java.util.*;

/**
 * 允许通过配置项duiba.datasource.*定义多个数据库连接池配置。
 */
public class DataSourceBeanDefinitionRegistryPostProcessor implements BeanDefinitionRegistryPostProcessor,EnvironmentAware {

    private static final Logger logger = LoggerFactory.getLogger(DataSourceBeanDefinitionRegistryPostProcessor.class);
    private static final String DATA_SOURCE_NAME_PREFIX = "DataSource";
    protected static final String DUIBA_DATA_SOURCE_CONFIG_PREFIX = "duiba.datasource";
    private DuibaDataSourceProperties duibaDataSourceProperties;
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if(duibaDataSourceProperties == null){
            return;
        }

        for(Map.Entry<String, DuibaDataSourceProperties.DataSourcePropertiesInner> entry : duibaDataSourceProperties.getDatasource().entrySet()){
            String dataSourceName = entry.getKey();
            String dataSourceBeanName = normalizationDataSourceName(dataSourceName);

            DuibaDataSourceProperties.DataSourcePropertiesInner props = entry.getValue();

            BeanDefinitionBuilder bdb = props.initializeDataSourceBeanDefinitionBuilder();
            if(bdb == null){
                logger.info("[统一连接池]检测到此dataSource:[duiba.datasource.{}]不完整的配置(缺少必需配置url)，忽略之", dataSourceName);
                continue;
            }
            BeanDefinition bd = bdb.getBeanDefinition();
            registry.registerBeanDefinition(dataSourceBeanName, bd);
        }
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected static String normalizationDataSourceName(String dataSourceName){
        if(!dataSourceName.endsWith(DATA_SOURCE_NAME_PREFIX)) {
            dataSourceName = dataSourceName + DATA_SOURCE_NAME_PREFIX;
        }
        return dataSourceName;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;

        PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)environment,DuibaDataSourceProperties.DUIBA_DATA_SOURCE_PROPERTIES_PREFIX);

        DuibaDataSourceProperties duibaDataSourceProperties = new DuibaDataSourceProperties();

        resolver.bindToConfig(duibaDataSourceProperties);

        if(duibaDataSourceProperties.getDatasource().isEmpty()){
            return;
        }

        this.duibaDataSourceProperties = duibaDataSourceProperties;
    }
}
