package cn.com.duibaboot.ext.autoconfigure.devtools.env;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Order(0)
public class DevToolsPropertiesPostProcessor implements EnvironmentPostProcessor {

    private static final Map<String, Object> properties;
    static {
        Map<String, Object> devToolsProperties = new HashMap<>();
        //配置禁用devtools liveboard特性
        devToolsProperties.put("spring.devtools.livereload.enabled", "false");
        properties = Collections.unmodifiableMap(devToolsProperties);
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertySource<?> propertySource = new MapPropertySource("duibaDevtoolsConfig",
                properties);
        environment.getPropertySources().addLast(propertySource);
    }

}
