package cn.com.duibaboot.ext.autoconfigure.logger.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import org.apache.commons.lang3.StringUtils;

import java.io.File;

/**
 * 对每个记录到文件中的日志在Cat中进行计数
 */
public class CatLoggerCountFilter extends Filter<ILoggingEvent> {

    private String fileName;

    public CatLoggerCountFilter(String fileName){
        if(StringUtils.isBlank(fileName)){
            return;
        }
        int sIndex = fileName.lastIndexOf(File.separator);
        int siffixIndex = fileName.lastIndexOf('.');
        if(siffixIndex <= sIndex || sIndex == -1){
            return;
        }
        this.fileName = fileName.substring(sIndex+1,siffixIndex);
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if(StringUtils.isNotBlank(fileName)
                && CatUtils.isCatEnabled()){
            Cat.logEvent("ILoggingEvent", fileName);
        }
        return FilterReply.NEUTRAL;
    }

}
