package cn.com.duibaboot.ext.autoconfigure.logger.filter;

import java.lang.reflect.Field;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import cn.com.duiba.boot.perftest.InternalPerfTestContext;

import org.springframework.util.ReflectionUtils;

/**
 * 在线程名后面附加Perf标记，表示当前线程在压测
 */
public class ThreadNameFilter extends Filter<ILoggingEvent> {

    private static final Field threadNameField;
    static{
        threadNameField = ReflectionUtils.findField(LoggingEvent.class, "threadName");
        threadNameField.setAccessible(true);
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (event instanceof LoggingEvent
            && InternalPerfTestContext.isCurrentInPerfTestMode()
            && ReflectionUtils.getField(threadNameField, event) == null) {
            try {
                ((LoggingEvent) event).setThreadName(Thread.currentThread().getName() + ":Perf");
            } catch (IllegalStateException e) {
                //Ignore
            }
        }
        return FilterReply.NEUTRAL;
    }

}
