package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import com.google.common.cache.CacheBuilder;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-16 15:35
 * @descript:
 * @version: 1.0
 */
@Slf4j
public class GuavaCacheBuilderInterceptor implements StaticMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {

    }

    @Override
    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {

        if(!"newBuilder".equals(method.getName())) {
            return ret;
        }

        try {
            CacheBuilder<Object, Object> cacheBuilder = (CacheBuilder<Object, Object>) ret;
            cacheBuilder.recordStats();
        } catch (Exception e) {
            log.error("cacheBuilder cast　exception", e);
        }

        return ret;
    }

    @Override
    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {

    }
}
