package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.*;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import com.esotericsoftware.kryo.KryoException;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * FlowReplayCustomizeSpan 注解切面，用于实际的回放
 * Created by guoyanfei .
 * 2019-05-23 .
 */
@Slf4j
@Aspect
public class ReplayRedisTemplatePlugin {

    @Around("execution(* org.springframework.data.redis.core.RedisTemplate.*(..))")
    public Object customizeSpanReplayAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        // 目前只拦截executePipelined方法
        if (!"executePipelined".equals(method.getName())) {
            return joinPoint.proceed();
        }

        // 当前不是回放的环境 或者 当前请求不是回放请求
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return joinPoint.proceed();
        }

        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();

        log.debug("RedisTemplatee的executePipelined方法回放_traceId={}_spanType={}_spanId={}", ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null);

        // 增加了新的调用 || 调用内容有变动
        if (span == null || SpanType.REDIS != span.getSpanType()) {
            String expert = SpanType.REDIS.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        RedisFlowReplaySpan redisSpan = (RedisFlowReplaySpan) span;

        // 方法名是否相同，此处比较的就是 executePipelined()
        if (!FlowReplayUtils.isMethodEqual(redisSpan.getMethodName(), method)) {
            String expert = redisSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_102, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        try {
            // 都相同mock返回值
            return redisSpan.getReturnValue();
        } catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_104, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }
}
