package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RemoteServiceFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Method;

/**
 * RemoteService 的回放器
 * Created by guoyanfei .
 * 2019-02-26 .
 */
public class RemoteServiceReplayer implements Replayer {

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        RemoteServiceFlowReplaySpan span = (RemoteServiceFlowReplaySpan) trace.getMainSpan();
        Object obj = applicationContext.getBean(toLowerCaseFirstOne(span.getTypeName()));

        ReplayTraceContext.create(trace);
        ReplayTraceContext context = null;
        Object replayResultValue = null;
        try {
            String[] parameterTypes = span.getParameterTypes();
            int parameterLength = parameterTypes.length;
            Class[] parameterTypeClasses = null;
            if (parameterLength > 0) {
                parameterTypeClasses = new Class[parameterLength];
                for (int i = 0; i < parameterLength; i++) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i]);
                }
            }
            Method method = ReflectionUtils.findMethod(obj.getClass(), span.getMethodName(), parameterTypeClasses);
            replayResultValue = ReflectionUtils.invokeMethod(method, obj, span.getParameterValues());
        } catch (ClassNotFoundException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_300);
        } finally {
            context = ReplayTraceContext.getAndRemove();
        }
        if (context == null) {
            throw new FlowReplayException("单个用例回放上下文丢失_traceId=" + trace.getTraceId());
        }
        if (context.isErrorMarked()) {
            return ReplayTraceResult.failResult(trace, context.getErrorMsgType(), context.getErrorMsgDetail());
        }
        return ReplayTraceResult.successResult(trace, replayResultValue);
    }

    /**
     * 字符串首字母小写
     * @param s
     * @return
     */
    private static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        } else {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
    }

}
