package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-23 16:15
 * @descript:
 * @version: 1.0
 */
@Slf4j
public class CacheBuildInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        //ignore
        System.out.println("obj = [" + obj + "], method = [" + method + "], allArguments = [" + allArguments + "], argumentsTypes = [" + argumentsTypes + "], result = [" + result + "]");
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {

        CacheMonitorManager.setBuilderCache(obj.hashCode(), ret);
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        log.error("CacheBuildInterceptor exception", t);
    }
}
