package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.cache.*;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-16 15:35
 * @descript:
 * @version: 1.0
 */
@Slf4j
public class CacheBuilderInterceptor implements StaticMethodsAroundInterceptor {

    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {

    }

    @Override
    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {

        if (!"newBuilder".equals(method.getName())) {
            return ret;
        }

        try {

            if (ret instanceof CacheBuilder) {
                CacheBuilder cacheBuilder = (CacheBuilder) ret;
                cacheBuilder.recordStats();
                if(this.isAlreadSetRemoval(cacheBuilder)) {
                    return ret;
                }

                RemovalListener<Object, Object> removalListener = RemovalListeners.asynchronous((notification -> {

                    if (notification.getKey() == null) {
                        return;
                    }

                    CacheChangeRecord changeRecord = new CacheChangeRecord();
                    changeRecord.setExpireDate(new Date());
                    changeRecord.setKey(notification.getKey());
                    changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(notification.getCause().name()));
                    changeRecord.setValue(JSON.toJSONString(notification.getValue()));
                    changeRecord.setBuilderHashcode(cacheBuilder.hashCode());
                    CacheMonitorManager.addRecord(changeRecord);

                }), executorService);
                return cacheBuilder.removalListener(removalListener);
            }

            if (ret instanceof Caffeine) {
                Caffeine caffeine = (Caffeine) ret;
                caffeine.recordStats();
                if(this.isAlreadSetRemoval(caffeine)) {
                    return ret;
                }

                return caffeine.removalListener((key, value, cause) -> {// 与guava不同，默认就是异步
                    CacheChangeRecord changeRecord = new CacheChangeRecord();
                    changeRecord.setExpireDate(new Date());
                    changeRecord.setKey(key);
                    changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(cause.name()));
                    changeRecord.setValue(JSON.toJSONString(value));
                    changeRecord.setBuilderHashcode(caffeine.hashCode());
                    CacheMonitorManager.addRecord(changeRecord);
                });
            }

        } catch (Exception e) {
            log.error("cacheBuilder afterMethod excetion", e);
        }

        return ret;
    }

    private boolean isAlreadSetRemoval(Object object) throws Exception {

        Field field = object.getClass().getDeclaredField("removalListener");
        field.setAccessible(true);
        boolean isRemoval = field.get(object) != null;
        field.setAccessible(false);
        return isRemoval;
    }

    @Override
    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {

    }
}
